<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\Plan;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class OrderSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();
        $plans = Plan::all();

        if ($users->isEmpty() || $plans->isEmpty()) {
            return;
        }

        foreach ($users as $user) {
            // Create a "Free Plan" entry for everyone
            Order::create([
                'user_id' => $user->id,
                'plan_id' => $plans->where('slug', 'free')->first()?->id ?: $plans->first()->id,
                'order_number' => 'ORD-' . strtoupper(Str::random(10)),
                'amount' => 0.00,
                'currency' => 'USD',
                'status' => 'completed',
                'payment_method' => 'system',
                'metadata' => ['note' => 'Initial free plan registration'],
            ]);

            // Add a paid order for some users
            if (rand(0, 1)) {
                $paidPlan = $plans->where('price', '>', 0)->random();
                if ($paidPlan) {
                    Order::create([
                        'user_id' => $user->id,
                        'plan_id' => $paidPlan->id,
                        'order_number' => 'ORD-' . strtoupper(Str::random(10)),
                        'amount' => $paidPlan->price,
                        'currency' => 'USD',
                        'status' => 'completed',
                        'payment_method' => 'stripe',
                        'metadata' => ['transaction_id' => 'ch_' . Str::random(24)],
                    ]);
                }
            }
        }
    }
}
