<?php

namespace Database\Seeders;

use App\Models\PaymentGateway;
use Illuminate\Database\Seeder;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Seed the payment gateways table with all supported gateways.
     * All gateways are inactive by default — the admin enables and
     * configures them via the settings panel.
     */
    public function run(): void
    {
        $gateways = [
            [
                'slug' => 'stripe',
                'name' => 'Stripe',
                'description' => 'Global card and digital wallet payments for 46+ countries.',
                'sort_order' => 1,
            ],
            [
                'slug' => 'paypal',
                'name' => 'PayPal',
                'description' => 'Worldwide online payments with buyer and seller protection.',
                'sort_order' => 2,
            ],
            [
                'slug' => 'razorpay',
                'name' => 'Razorpay',
                'description' => 'Full-stack payment gateway popular in India with UPI support.',
                'sort_order' => 3,
            ],
            [
                'slug' => 'paytm',
                'name' => 'Paytm',
                'description' => 'India-focused digital payments with wallet and UPI options.',
                'sort_order' => 4,
            ],
            [
                'slug' => 'mollie',
                'name' => 'Mollie',
                'description' => 'European payment gateway supporting iDEAL, Bancontact, and more.',
                'sort_order' => 5,
            ],
            [
                'slug' => 'paystack',
                'name' => 'Paystack',
                'description' => 'Leading payment gateway for businesses in Africa.',
                'sort_order' => 6,
            ],
            [
                'slug' => 'flutterwave',
                'name' => 'Flutterwave',
                'description' => 'Pan-African payments supporting mobile money and bank transfers.',
                'sort_order' => 7,
            ],
            [
                'slug' => 'square',
                'name' => 'Square',
                'description' => 'US, Canada, Australia, Japan, and UK commerce and payments platform.',
                'sort_order' => 8,
            ],
            [
                'slug' => 'braintree',
                'name' => 'Braintree',
                'description' => 'PayPal-owned gateway with card, PayPal, and Venmo support.',
                'sort_order' => 9,
            ],
            [
                'slug' => 'twocheckout',
                'name' => '2Checkout (Verifone)',
                'description' => 'Global monetization platform for digital goods and subscriptions.',
                'sort_order' => 10,
            ],
            [
                'slug' => 'coinbase',
                'name' => 'Coinbase Commerce',
                'description' => 'Accept cryptocurrency payments including Bitcoin and Ethereum.',
                'sort_order' => 11,
            ],
            [
                'slug' => 'mercadopago',
                'name' => 'Mercado Pago',
                'description' => 'Leading payment gateway in Latin America with local payment methods.',
                'sort_order' => 12,
            ],
            [
                'slug' => 'iyzico',
                'name' => 'iyzico',
                'description' => 'Turkish payment gateway with installment and marketplace support.',
                'sort_order' => 13,
            ],
            [
                'slug' => 'paddle',
                'name' => 'Paddle',
                'description' => 'Merchant of record for SaaS and digital products with tax handling.',
                'sort_order' => 14,
            ],
            [
                'slug' => 'authorize_net',
                'name' => 'Authorize.net',
                'description' => 'Established US payment gateway by Visa for card and eCheck processing.',
                'sort_order' => 15,
            ],
            [
                'slug' => 'sslcommerz',
                'name' => 'SSLCommerz',
                'description' => 'Bangladesh payment gateway supporting bKash, Nagad, and local banks.',
                'sort_order' => 16,
            ],
            [
                'slug' => 'instamojo',
                'name' => 'Instamojo',
                'description' => 'Indian payment gateway for small businesses and freelancers.',
                'sort_order' => 17,
            ],
            [
                'slug' => 'phonepe',
                'name' => 'PhonePe',
                'description' => 'India UPI-based payment gateway with wide consumer adoption.',
                'sort_order' => 18,
            ],
            [
                'slug' => 'cashfree',
                'name' => 'Cashfree',
                'description' => 'Indian payment gateway with instant settlements and payouts.',
                'sort_order' => 19,
            ],
            [
                'slug' => 'payu',
                'name' => 'PayU',
                'description' => 'Payment gateway operating in India, Latin America, and Eastern Europe.',
                'sort_order' => 20,
            ],
            [
                'slug' => 'midtrans',
                'name' => 'Midtrans',
                'description' => 'Indonesian payment gateway supporting e-wallets and bank transfers.',
                'sort_order' => 21,
            ],
            [
                'slug' => 'xendit',
                'name' => 'Xendit',
                'description' => 'Southeast Asian payment gateway for Indonesia and the Philippines.',
                'sort_order' => 22,
            ],
            [
                'slug' => 'tap',
                'name' => 'Tap',
                'description' => 'Middle Eastern payment gateway for GCC and MENA region merchants.',
                'sort_order' => 23,
            ],
            [
                'slug' => 'hyperpay',
                'name' => 'HyperPay',
                'description' => 'MENA region payment platform supporting Mada, STC Pay, and Apple Pay.',
                'sort_order' => 24,
            ],
            [
                'slug' => 'paytr',
                'name' => 'PayTR',
                'description' => 'Turkish payment gateway with virtual POS and installment options.',
                'sort_order' => 25,
            ],
            [
                'slug' => 'fondy',
                'name' => 'Fondy',
                'description' => 'Eastern European payment gateway with multi-currency support.',
                'sort_order' => 26,
            ],
            [
                'slug' => 'skrill',
                'name' => 'Skrill',
                'description' => 'Global digital wallet for cross-border payments and transfers.',
                'sort_order' => 27,
            ],
            [
                'slug' => 'cinetpay',
                'name' => 'CinetPay',
                'description' => 'West African payment gateway supporting mobile money and Orange Money.',
                'sort_order' => 28,
            ],
            [
                'slug' => 'bank_transfer',
                'name' => 'Bank Transfer (Manual)',
                'description' => 'Offline bank transfer with manual payment confirmation by admin.',
                'sort_order' => 29,
            ],
            [
                'slug' => 'offline',
                'name' => 'Offline Payment',
                'description' => 'Manual or cash payments verified and marked complete by admin.',
                'sort_order' => 30,
            ],
        ];

        // Supported currencies per gateway (from official docs).
        // Empty array = accepts any currency (bank_transfer, offline).
        $currencyMap = [
            'stripe'        => ['USD','EUR','GBP','JPY','CAD','AUD','CHF','INR','BRL','MXN','SGD','HKD','NOK','SEK','DKK','PLN','CZK','RON','HUF','NZD','MYR','THB','PHP','IDR','TRY','ZAR','KES','NGN','AED','SAR','EGP','ILS','KRW','TWD','CNY'],
            'paypal'        => ['USD','EUR','GBP','JPY','CAD','AUD','CHF','INR','BRL','MXN','SGD','HKD','NOK','SEK','DKK','PLN','CZK','HUF','NZD','PHP','THB','TRY','ILS','TWD','CNY','RUB'],
            'razorpay'      => ['INR'],
            'paytm'         => ['INR'],
            'mollie'        => ['EUR','USD','GBP','CHF','SEK','NOK','DKK','PLN','CZK','HUF','RON'],
            'paystack'      => ['NGN','GHS','ZAR','USD','KES'],
            'flutterwave'   => ['NGN','USD','KES','EUR','GBP','GHS','ZAR','TZS','UGX','RWF','XOF','XAF'],
            'square'        => ['USD','CAD','GBP','AUD','JPY','EUR'],
            'braintree'     => ['USD','EUR','GBP','CAD','AUD','JPY','CHF','NOK','SEK','DKK','HKD','SGD','NZD','BRL','MXN','PLN','CZK','HUF'],
            'twocheckout'   => ['USD','EUR','GBP','JPY','CAD','AUD','CHF','BRL','MXN','SGD','HKD','NOK','SEK','DKK','PLN','CZK','HUF','RON','TRY','ZAR','INR','NZD','ILS'],
            'coinbase'      => ['USD','EUR','GBP','BTC','ETH','USDC'],
            'mercadopago'   => ['BRL','ARS','MXN','CLP','COP','PEN','UYU'],
            'iyzico'        => ['TRY','USD','EUR','GBP'],
            'paddle'        => ['USD','EUR','GBP','AUD','CAD','CHF','SEK','NOK','DKK','PLN','CZK','HUF','BRL','SGD','HKD','NZD','MXN','JPY','KRW','TWD','TRY','ZAR','INR','THB','ARS'],
            'authorize_net' => ['USD','CAD','EUR','GBP','AUD'],
            'sslcommerz'    => ['BDT'],
            'instamojo'     => ['INR'],
            'phonepe'       => ['INR'],
            'cashfree'      => ['INR'],
            'payu'          => ['INR'],
            'midtrans'      => ['IDR'],
            'xendit'        => ['IDR','PHP','USD','VND','MYR','THB'],
            'tap'           => ['KWD','SAR','AED','BHD','QAR','OMR','JOD','EGP','USD','EUR','GBP'],
            'hyperpay'      => ['SAR','AED','USD','EUR','GBP','BHD','KWD','QAR','OMR','JOD','EGP'],
            'paytr'         => ['TRY','USD','EUR','GBP'],
            'fondy'         => ['EUR','USD','GBP','UAH','PLN','CZK','RON','HUF','RUB'],
            'skrill'        => ['EUR','USD','GBP','CAD','AUD','CHF','SEK','NOK','DKK','PLN','CZK','HUF','RON','TRY','BRL'],
            'cinetpay'      => ['XOF','XAF','CDF','GNF','USD'],
            'bank_transfer' => [],
            'offline'       => [],
        ];

        foreach ($gateways as $gateway) {
            PaymentGateway::firstOrCreate(
                ['slug' => $gateway['slug']],
                [
                    'name' => $gateway['name'],
                    'description' => $gateway['description'],
                    'is_active' => false,
                    'mode' => 'sandbox',
                    'sort_order' => $gateway['sort_order'],
                    'supported_currencies' => $currencyMap[$gateway['slug']] ?? [],
                ]
            );
        }

        // Update existing rows that don't yet have supported_currencies set
        foreach ($currencyMap as $slug => $currencies) {
            PaymentGateway::where('slug', $slug)
                ->whereNull('supported_currencies')
                ->update(['supported_currencies' => json_encode($currencies)]);
        }
    }
}
