<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $modules = [
            'activity-logs' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'blocked-ips' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'blocked-locations' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'blog-categories' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'blog-posts' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'cities' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'countries' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'coupons' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'currencies' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'events' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'fact-stats' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'faqs' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'languages' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'pages' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'permissions' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'payment-gateways' => ['view', 'update'],
            'plans' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'roles' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'security-audit-logs' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'states' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'support-tickets' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'system-logs' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'testimonials' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'ticket-assignments' => ['view', 'create', 'update', 'delete', 'export', 'import'],
            'newsletter-subscribers' => ['view', 'delete', 'export'],
            'users' => ['view', 'create', 'update', 'delete', 'export'],
            'user-delete-requests' => ['view', 'update'],
            'reports' => ['view', 'export'],
            'extensions' => ['view', 'update'],
            'security-settings' => ['view', 'update'],
            'system-settings' => ['view', 'update'],
        ];

        foreach ($modules as $module => $actions) {
            foreach ($actions as $action) {
                Permission::firstOrCreate([
                    'name' => $module . '.' . $action,
                    'guard_name' => 'web',
                ]);
            }
        }
    }
}
