<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class PhotographerPermissionSeeder extends Seeder
{
    public function run(): void
    {
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        $role = Role::query()->where('name', 'Photographer')->first();
        if (! $role) {
            return;
        }

        $permissions = Permission::query()->whereIn('name', [
            'events.view',
            'events.create',
            'events.update',
            'events.delete',
            'reports.view',
            'reports.export',
            'support-tickets.view',
            'support-tickets.create',
        ])->get();

        $role->syncPermissions($permissions);
    }
}
