<?php

namespace Database\Seeders;

use App\Models\Coupon;
use App\Models\Plan;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PlanSeeder extends Seeder
{
    public function run(): void
    {
        $creatorId = User::query()->where('email', 'test@example.com')->value('id');

        $plans = [
            [
                'name' => 'Free',
                'price' => 0,
                'offer_price' => null,
                'features' => ['1 active event', '500 photos', 'Basic sharing'],
                'images_limit' => 500,
                'events_limit' => 1,
                'duration_type' => 'lifetime',
                'duration_months' => null,
            ],
            [
                'name' => 'Pro',
                'price' => 49,
                'offer_price' => 39,
                'features' => ['10 active events', '5,000 photos', 'Watermarking', 'Priority support'],
                'images_limit' => 5000,
                'events_limit' => 10,
                'duration_type' => 'months',
                'duration_months' => 1,
            ],
            [
                'name' => 'Studio',
                'price' => 199,
                'offer_price' => 159,
                'features' => ['Unlimited events', 'Unlimited photos', 'Custom branding', 'Dedicated success'],
                'images_limit' => null,
                'events_limit' => null,
                'duration_type' => 'months',
                'duration_months' => 1,
            ],
        ];

        $planModels = [];

        foreach ($plans as $plan) {
            $slug = Str::slug($plan['name']);

            $planModels[$slug] = Plan::updateOrCreate(
                ['slug' => $slug],
                [
                    'name' => $plan['name'],
                    'price' => $plan['price'],
                    'offer_price' => $plan['offer_price'],
                    'features' => $plan['features'],
                    'images_limit' => $plan['images_limit'],
                    'events_limit' => $plan['events_limit'],
                    'duration_type' => $plan['duration_type'],
                    'duration_months' => $plan['duration_months'],
                    'is_active' => true,
                    'created_by' => $creatorId,
                ]
            );
        }

        $coupons = [
            [
                'name' => 'Welcome 10',
                'code' => 'WELCOME10',
                'discount_type' => 'percent',
                'discount_value' => 10,
                'min_amount' => 25,
                'new_users_only' => true,
                'plans' => ['pro', 'studio'],
            ],
            [
                'name' => 'Studio Launch',
                'code' => 'STUDIO20',
                'discount_type' => 'percent',
                'discount_value' => 20,
                'min_amount' => 100,
                'new_users_only' => false,
                'plans' => ['studio'],
            ],
        ];

        foreach ($coupons as $couponData) {
            $coupon = Coupon::updateOrCreate(
                ['code' => $couponData['code']],
                [
                    'name' => $couponData['name'],
                    'discount_type' => $couponData['discount_type'],
                    'discount_value' => $couponData['discount_value'],
                    'min_amount' => $couponData['min_amount'],
                    'starts_at' => now()->subDays(2),
                    'ends_at' => now()->addMonths(3),
                    'new_users_only' => $couponData['new_users_only'],
                    'is_active' => true,
                    'created_by' => $creatorId,
                ]
            );

            $planIds = collect($couponData['plans'])
                ->map(fn ($slug) => $planModels[$slug]?->id)
                ->filter()
                ->values()
                ->all();

            if ($planIds) {
                $coupon->plans()->syncWithoutDetaching($planIds);
            }
        }
    }
}
