<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        $allPermissions = Permission::query()->pluck('name')->all();

        // Super Admin — full system access (also has Gate::before bypass)
        $superAdmin = Role::query()->where('name', 'Super Admin')->first();
        if ($superAdmin) {
            $superAdmin->givePermissionTo($allPermissions);
        }

        // Admin — full access except role/permission/security/system management
        $admin = Role::query()->where('name', 'Admin')->first();
        if ($admin) {
            $adminPermissions = Permission::query()
                ->whereNotIn('name', [
                    'roles.create', 'roles.update', 'roles.delete',
                    'permissions.create', 'permissions.update', 'permissions.delete',
                    'security-settings.update',
                    'system-settings.update',
                ])
                ->pluck('name')
                ->all();

            $admin->syncPermissions($adminPermissions);
        }

        // Photographer — event management, watermark positioning, reports & support
        $photographer = Role::query()->where('name', 'Photographer')->first();
        if ($photographer) {
            $photographerPermissions = Permission::query()->whereIn('name', [
                'events.view',
                'events.create',
                'events.update',
                'events.delete',
                'reports.view',
                'reports.export',
                'support-tickets.view',
                'support-tickets.create',
            ])->pluck('name')->all();

            $photographer->syncPermissions($photographerPermissions);
        }

        // User — basic event management (default role for registered users)
        $userRole = Role::query()->where('name', 'User')->first();
        if ($userRole) {
            $userPermissions = Permission::query()->whereIn('name', [
                'events.view',
                'events.create',
                'events.update',
                'events.delete',
            ])->pluck('name')->all();

            $userRole->syncPermissions($userPermissions);
        }

        // Support Agent — ticket and assignment management
        $supportAgent = Role::query()->where('name', 'Support Agent')->first();
        if ($supportAgent) {
            $supportPermissions = Permission::query()->whereIn('name', [
                'support-tickets.view',
                'support-tickets.create',
                'support-tickets.update',
                'support-tickets.delete',
                'support-tickets.export',
                'support-tickets.import',
                'ticket-assignments.view',
                'ticket-assignments.create',
                'ticket-assignments.update',
                'ticket-assignments.delete',
                'ticket-assignments.export',
                'ticket-assignments.import',
            ])->pluck('name')->all();

            $supportAgent->syncPermissions($supportPermissions);
        }
    }
}
