<?php

namespace Database\Seeders;

use App\Models\SupportTicket;
use App\Models\SupportTicketAssignment;
use App\Models\User;
use Illuminate\Database\Seeder;

class SupportSeeder extends Seeder
{
    public function run(): void
    {
        $creatorId = User::query()->where('email', 'test@example.com')->value('id');
        $supportId = User::query()->where('email', 'maya.support@example.com')->value('id');

        $tickets = [
            [
                'ticket_number' => 'TKT-10001',
                'subject' => 'Gallery link not loading',
                'message' => 'Guests see a blank screen when opening the share link.',
                'requester_name' => 'James Carter',
                'requester_email' => 'james.carter@example.com',
                'priority' => 'high',
                'status' => 'open',
            ],
            [
                'ticket_number' => 'TKT-10002',
                'subject' => 'Upload limit question',
                'message' => 'How many photos can I upload on the Pro plan?',
                'requester_name' => 'Lina Gomez',
                'requester_email' => 'lina.gomez@example.com',
                'priority' => 'medium',
                'status' => 'open',
            ],
        ];

        foreach ($tickets as $ticketData) {
            $ticket = SupportTicket::updateOrCreate(
                ['ticket_number' => $ticketData['ticket_number']],
                [
                    'subject' => $ticketData['subject'],
                    'message' => $ticketData['message'],
                    'requester_name' => $ticketData['requester_name'],
                    'requester_email' => $ticketData['requester_email'],
                    'requester_phone' => null,
                    'priority' => $ticketData['priority'],
                    'status' => $ticketData['status'],
                    'is_active' => true,
                    'created_by' => $creatorId,
                ]
            );

            if ($supportId) {
                SupportTicketAssignment::updateOrCreate(
                    [
                        'support_ticket_id' => $ticket->id,
                        'assigned_to' => $supportId,
                    ],
                    [
                        'assigned_by' => $creatorId,
                        'note' => 'Assigned for follow-up.',
                        'is_active' => true,
                        'assigned_at' => now(),
                    ]
                );
            }
        }
    }
}
