<?php

namespace Database\Seeders;

use App\Models\SystemSetting;
use Illuminate\Database\Seeder;

class SystemSettingsSeeder extends Seeder
{
    public function run(): void
    {
        $socialProviders = config('system.social_providers', []);
        $defaultProviders = [];

        foreach ($socialProviders as $key => $label) {
            $defaultProviders[$key] = [
                'enabled' => false,
                'client_id' => '',
                'client_secret' => '',
                'redirect_url' => '',
            ];
        }

        $defaults = [
            'general' => [
                'default_language' => 'en',
                'default_currency' => 'USD',
                'default_timezone' => config('app.timezone', 'UTC'),
                'date_format' => 'M d, Y',
                'time_format' => 'h:i A',
                'support_email' => 'support@SnapNest.test',
                'support_phone' => '+1 415 555 0110',
                'enable_multi_language' => true,
            ],
            'site' => [
                'site_name' => 'SnapNest',
                'site_logo' => null,
                'favicon' => null,
                'admin_logo' => null,
                'company_name' => 'SnapNest Labs',
                'company_address' => '101 Market Street, San Francisco, CA',
                'company_country_id' => null,
                'company_state_id' => null,
                'company_city_id' => null,
                'company_phone' => '+1 415 555 0110',
                'business_hours' => 'Mon-Fri 9:00 AM - 6:00 PM',
                'latitude' => '37.7749',
                'longitude' => '-122.4194',
                'right_click_disable' => false,
                'uc_browser_block' => false,
            ],
            'smtp' => [
                'smtp_host' => '',
                'smtp_port' => '',
                'smtp_username' => '',
                'smtp_password' => '',
                'smtp_encryption' => 'tls',
                'smtp_from_address' => 'no-reply@SnapNest.test',
                'smtp_from_name' => 'SnapNest',
            ],
            'footer' => [
                'footer_logo' => null,
                'footer_social' => [
                    'facebook' => 'https://facebook.com/SnapNest',
                    'x' => 'https://x.com/SnapNest',
                    'linkedin' => 'https://linkedin.com/company/SnapNest',
                    'instagram' => 'https://instagram.com/SnapNest',
                    'whatsapp' => '',
                ],
                'app_links' => [
                    'android' => '',
                    'ios' => '',
                    'direct' => '',
                ],
            ],
            'seo' => [
                'meta_title' => 'SnapNest - Event Photo Galleries',
                'meta_description' => 'Secure event galleries with watermarking, sharing, and print-ready originals.',
                'meta_keywords' => 'event gallery, photo sharing, watermark, photo delivery',
                'sitemap_enabled' => true,
                'robots_txt' => "User-agent: *\nAllow: /",
                'llm_txt' => '',
            ],
            'social' => [
                'providers' => $defaultProviders,
            ],
            'gdpr' => [
                'gdpr_enabled' => true,
                'gdpr_message' => 'We use cookies to personalize content and analyze traffic.',
                'gdpr_accept_label' => 'Accept',
                'gdpr_decline_label' => 'Decline',
            ],
            'media' => [
                'max_file_size' => (int) config('events.media.max_file_size', 51200),
                'chunk_size' => (int) config('events.media.chunk_size', 5242880),
                'max_width' => (int) config('events.media.max_width', 2000),
                'thumbnail_width' => (int) config('events.media.thumbnail_width', 600),
                'quality' => (int) config('events.media.quality', 82),
                'storage_limit_gb' => (float) config('events.media.storage_limit_gb', 6.1),
                'watermark' => [
                    'enabled' => true,
                    'image' => null,
                    'position' => 'top_right',
                ],
                'ftp_path' => (string) config('events.media.ftp_path', storage_path('app/ftp')),
            ],
            'maintenance' => [
                'maintenance_enabled' => false,
                'maintenance_message' => '',
            ],
            'extensions' => [
                'analytics' => [
                    'google_enabled' => false,
                    'google_measurement_id' => '',
                ],
                'adsense' => [
                    'adsense_enabled' => false,
                    'adsense_client_id' => '',
                ],
                'facebook' => [
                    'pixel_enabled' => false,
                    'pixel_id' => '',
                ],
                'microsoft' => [
                    'uet_enabled' => false,
                    'uet_tag_id' => '',
                ],
                'social' => [
                    'og_enabled' => true,
                    'og_title' => 'SnapNest Event Gallery',
                    'og_description' => 'Share galleries with secure access and watermarking.',
                    'og_image' => null,
                ],
            ],
            'pwa' => [
                'enabled'          => true,
                'app_name'         => 'SnapNest',
                'app_url'          => '/',
                'icon'             => null,
                'splash_screen'    => null,
                'theme_color'      => '#156055',
                'background_color' => '#f5f0e8',
            ],
            'security' => [
                'max_login_attempts' => 5,
                'lockout_minutes' => 1,
                'captcha_enabled' => false,
                'captcha_site_key' => '',
                'captcha_secret_key' => '',
                'two_factor_admin_only' => false,
                'two_factor_issuer' => 'SnapNest Admin',
            ],
        ];

        $setting = SystemSetting::query()->firstOrCreate([]);
        $payload = $setting->payload ?? [];
        $setting->payload = array_replace_recursive($defaults, $payload);
        $setting->save();
    }
}
