<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Create Super Admin user
        $user = User::updateOrCreate(
            ['email' => 'admin@mediacity.co.in'],
            [
                'name' => 'Super Admin',
                'phone' => '+91 9876543210',
                'gender' => 'male',
                'email_verified_at' => now(),
                'is_active' => true,
                'password' => Hash::make('12345678'),
            ]
        );

        $user->syncRoles(['Super Admin']);

        echo "✅ Super Admin created successfully!\n";
        echo "Email: admin@mediacity.co.in\n";
        echo "Password: 12345678\n";
    }
}
