<x-admin-layout :title="__('Activity Logs')" :subtitle="__('Track user actions and system events.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Activity Logs') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Monitor key actions taken across the platform.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-activity-logs')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/activity-logs.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.activity-logs.create') }}" class="btn-primary">{{ __('Add Activity') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search action, subject, or description') }}">
                </div>
                <div>
                    <label class="sr-only" for="action">{{ __('Action') }}</label>
                    <select id="action" name="action" class="input-field">
                        <option value="">{{ __('All actions') }}</option>
                        @foreach ($actions as $value => $label)
                            <option value="{{ $value }}" @selected($action === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="user">{{ __('User') }}</label>
                    <select id="user" name="user" class="input-field">
                        <option value="">{{ __('All users') }}</option>
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}" @selected((string) $userId === (string) $user->id)>{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                        <option value="action_asc" @selected($sort === 'action_asc')>{{ __('Action (A-Z)') }}</option>
                        <option value="action_desc" @selected($sort === 'action_desc')>{{ __('Action (Z-A)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.activity-logs.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="activity-logs-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Activity Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing :count of :total activities.', ['count' => $logs->count(), 'total' => $logs->total()]) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.activity-logs.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-activity-log-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Action') }}</th>
                            <th class="pb-3">{{ __('User') }}</th>
                            <th class="pb-3">{{ __('Subject') }}</th>
                            <th class="pb-3">{{ __('Logged') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($logs as $log)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $log->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $actions[$log->action] ?? ucfirst($log->action) }}</p>
                                    <p class="text-xs text-muted">{{ \Illuminate\Support\Str::limit($log->description, 60) }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $log->user?->name ?? __('System') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $log->subject_type ? class_basename($log->subject_type) : __('N/A') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $log->logged_at ? \App\Support\FormatSettings::dateTime($log->logged_at) : '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.activity-logs.show', $log) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.activity-logs.edit', $log) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-activity-log-delete-{{ $log->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-activity-log-delete-{{ $log->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.activity-logs.destroy', $log) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this activity?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No activities found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($logs as $log)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $actions[$log->action] ?? ucfirst($log->action) }}</p>
                                <p class="text-xs text-muted">{{ $log->user?->name ?? __('System') }}</p>
                            </div>
                            <span class="badge">{{ $log->logged_at ? \App\Support\FormatSettings::date($log->logged_at) : '-' }}</span>
                        </div>
                        <div class="mt-3 text-xs text-muted">{{ $log->subject_type ? class_basename($log->subject_type) : __('N/A') }}</div>
                        <div class="mt-2 text-xs text-muted">{{ \Illuminate\Support\Str::limit($log->description, 120) }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.activity-logs.show', $log) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.activity-logs.edit', $log) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No activities found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-activity-log-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.activity-logs.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected activities?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {{ __('You are about to remove') }} <span class="font-semibold text-ink" data-bulk-selected>0</span> {{ __('activity(s).') }}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-activity-logs" :show="false" focusable>
                <form method="POST" action="{{ route('admin.activity-logs.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Activity Logs') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="activity_logs_file" :value="__('CSV File')" />
                        <input id="activity_logs_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $logs->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
