@php
    $isEdit = isset($log) && $log;
    $selectedUser = old('user_id', $isEdit ? $log->user_id : null);
@endphp

<div class="grid gap-6 lg:grid-cols-3">
    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Activity Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="user_id" :value="__('User')" />
                <select id="user_id" name="user_id" class="input-field mt-1">
                    <option value="">{{ __('System') }}</option>
                    @foreach ($users as $user)
                        <option value="{{ $user->id }}" @selected((string) $selectedUser === (string) $user->id)>{{ $user->name }} ({{ $user->email }})</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('user_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="action" :value="__('Action')" />
                <select id="action" name="action" class="input-field mt-1" required>
                    @foreach ($actions as $value => $label)
                        <option value="{{ $value }}" @selected(old('action', $isEdit ? $log->action : '') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('action')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="subject_type" :value="__('Subject Type')" />
                <x-text-input id="subject_type" name="subject_type" type="text" class="mt-1" :value="old('subject_type', $isEdit ? $log->subject_type : '')" placeholder="App\\Models\\Event" />
                <x-input-error :messages="$errors->get('subject_type')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="subject_id" :value="__('Subject ID')" />
                <x-text-input id="subject_id" name="subject_id" type="number" class="mt-1" :value="old('subject_id', $isEdit ? $log->subject_id : '')" />
                <x-input-error :messages="$errors->get('subject_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="description" :value="__('Description')" />
                <textarea id="description" name="description" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('description', $isEdit ? $log->description : '') }}</textarea>
                <x-input-error :messages="$errors->get('description')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Context') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="ip_address" :value="__('IP Address')" />
                <x-text-input id="ip_address" name="ip_address" type="text" class="mt-1" :value="old('ip_address', $isEdit ? $log->ip_address : '')" />
                <x-input-error :messages="$errors->get('ip_address')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="user_agent" :value="__('User Agent')" />
                <textarea id="user_agent" name="user_agent" rows="3" class="input-field mt-1" data-no-wysiwyg>{{ old('user_agent', $isEdit ? $log->user_agent : '') }}</textarea>
                <x-input-error :messages="$errors->get('user_agent')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="logged_at" :value="__('Logged At')" />
                <x-text-input id="logged_at" name="logged_at" type="datetime-local" class="mt-1" :value="old('logged_at', $isEdit && $log->logged_at ? $log->logged_at->format('Y-m-d\\TH:i') : '')" />
                <x-input-error :messages="$errors->get('logged_at')" class="mt-2" />
            </div>
        </div>
    </div>
</div>
