<x-admin-layout :title="__('Activity Log Details')" :subtitle="__('Review action context and metadata.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Activity') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $actions[$log->action] ?? ucfirst($log->action) }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $log->description ?: __('No description provided.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.activity-logs.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.activity-logs.edit', $log) }}" class="btn-primary">{{ __('Edit Activity') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('User') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->user?->name ?? __('System') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $log->user?->email ?? __('N/A') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Subject') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->subject_type ? class_basename($log->subject_type) : __('N/A') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ __('ID:') }} {{ $log->subject_id ?: __('N/A') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Logged At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->logged_at ? \App\Support\FormatSettings::dateTime($log->logged_at) : '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('IP Address') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->ip_address ?: __('N/A') }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('User Agent') }}</p>
            <p class="mt-3 text-sm text-muted">{{ $log->user_agent ?: __('No user agent available.') }}</p>
        </div>
    </div>
</x-admin-layout>
