<x-admin-layout :title="__('Contact Queries')" :subtitle="__('View messages from the contact form.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Contact Messages') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('View and manage contact form submissions.') }}</p>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search name, email, or message') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="new" @selected($status === 'new')>{{ __('New') }}</option>
                        <option value="read" @selected($status === 'read')>{{ __('Read') }}</option>
                        <option value="replied" @selected($status === 'replied')>{{ __('Replied') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.contact-queries.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope>
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Messages') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing :count of :total messages.', ['count' => $queries->count(), 'total' => $queries->total()]) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-query-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Name') }}</th>
                            <th class="pb-3">{{ __('Email') }}</th>
                            <th class="pb-3">{{ __('Message') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Date') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse($queries as $query)
                        <tr>
                            <td class="py-4">
                                <input type="checkbox" value="{{ $query->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                            </td>
                            <td class="py-4 font-semibold text-ink">{{ $query->first_name }} {{ $query->last_name }}</td>
                            <td class="py-4 text-sm text-ink">{{ $query->email }}</td>
                            <td class="py-4 text-sm text-ink max-w-xs truncate">{{ Str::limit($query->message, 60) }}</td>
                            <td class="py-4 text-sm">
                                @if($query->status === 'new')
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-400">{{ __('New') }}</span>
                                @elseif($query->status === 'read')
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-gray-100 text-gray-600 dark:bg-gray-800 dark:text-gray-400">{{ __('Read') }}</span>
                                @else
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400">{{ __('Replied') }}</span>
                                @endif
                            </td>
                            <td class="py-4 text-sm text-ink">{{ $query->created_at->format('M d, Y H:i') }}</td>
                            <td class="py-4 text-right">
                                <div class="inline-flex items-center gap-2">
                                    <a href="{{ route('admin.contact-queries.show', $query) }}" class="btn-secondary">{{ __('View') }}</a>
                                    <button type="button" class="btn-danger" x-data="" x-on:click.prevent="if(confirm('{{ __('Delete this query?') }}')) $el.closest('td').querySelector('form').submit()">{{ __('Delete') }}</button>
                                    <form method="POST" action="{{ route('admin.contact-queries.destroy', $query) }}" class="hidden">
                                        @csrf @method('DELETE')
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No contact queries yet.') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($queries->hasPages())
            <div class="mt-6">{{ $queries->links() }}</div>
            @endif
        </div>
    </div>

    {{-- Bulk Delete Modal --}}
    <div data-modal="confirm-query-bulk-delete" class="modal hidden">
        <div class="modal-content">
            <h3 class="text-lg font-bold">{{ __('Delete Selected Queries') }}</h3>
            <p class="mt-2 text-sm text-muted">{{ __('Are you sure you want to delete the selected contact queries? This action cannot be undone.') }}</p>
            <form method="POST" action="{{ route('admin.contact-queries.bulk-destroy') }}" class="mt-4 flex justify-end gap-3">
                @csrf @method('DELETE')
                <input type="hidden" name="ids" data-bulk-ids>
                <button type="button" class="btn-secondary" data-modal-close>{{ __('Cancel') }}</button>
                <button type="submit" class="btn-danger">{{ __('Delete') }}</button>
            </form>
        </div>
    </div>
</x-admin-layout>
