<x-admin-layout :title="__('Contact Query')" :subtitle="__('From') . ' ' . $contactQuery->first_name . ' ' . $contactQuery->last_name">

    <div class="max-w-3xl space-y-6">
        <div class="panel p-6">
            <p class="panel-heading">{{ __('Message Details') }}</p>
            <div class="mt-4 grid gap-4">
                <div class="grid gap-4 sm:grid-cols-2">
                    <div>
                        <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('Name') }}</p>
                        <p class="mt-1 font-medium">{{ $contactQuery->first_name }} {{ $contactQuery->last_name }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('Email') }}</p>
                        <p class="mt-1 font-medium">
                            <a href="mailto:{{ $contactQuery->email }}" class="text-brand hover:underline">{{ $contactQuery->email }}</a>
                        </p>
                    </div>
                </div>
                <div class="grid gap-4 sm:grid-cols-3">
                    <div>
                        <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('Status') }}</p>
                        <p class="mt-1">
                            @if($contactQuery->status === 'new')
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-400">{{ __('New') }}</span>
                            @elseif($contactQuery->status === 'read')
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-gray-100 text-gray-600 dark:bg-gray-800 dark:text-gray-400">{{ __('Read') }}</span>
                            @else
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full text-xs font-bold bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400">{{ __('Replied') }}</span>
                            @endif
                        </p>
                    </div>
                    <div>
                        <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('Date') }}</p>
                        <p class="mt-1 text-sm">{{ $contactQuery->created_at->format('M d, Y \a\t H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('IP Address') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ $contactQuery->ip_address ?? __('N/A') }}</p>
                    </div>
                </div>
                <div>
                    <p class="text-xs font-bold uppercase tracking-widest text-muted">{{ __('Message') }}</p>
                    <div class="mt-2 p-4 rounded-xl bg-muted/30 border border-border/50 text-sm leading-relaxed whitespace-pre-wrap">{{ $contactQuery->message }}</div>
                </div>
            </div>
        </div>

        <div class="flex flex-wrap items-center justify-between gap-3">
            <a href="{{ route('admin.contact-queries.index') }}" class="btn-secondary">{{ __('Back to List') }}</a>
            <form method="POST" action="{{ route('admin.contact-queries.destroy', $contactQuery) }}" onsubmit="return confirm('{{ __('Delete this query?') }}')">
                @csrf @method('DELETE')
                <button type="submit" class="btn-danger">{{ __('Delete') }}</button>
            </form>
        </div>
    </div>

</x-admin-layout>
