<x-admin-layout :title="__('Blog Categories')" :subtitle="__('Organize posts by category and topic.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Category Library') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Keep blog organization consistent across the site.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-blog-categories')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/blog-categories.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.blog-categories.create') }}" class="btn-primary">{{ __('Add Category') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search name or slug') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="name_asc" @selected($sort === 'name_asc')>{{ __('Name (A-Z)') }}</option>
                        <option value="name_desc" @selected($sort === 'name_desc')>{{ __('Name (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.blog-categories.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="blog-categories-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Category Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing :count of :total categories.', ['count' => $categories->count(), 'total' => $categories->total()]) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.blog-categories.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-blog-category-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Category') }}</th>
                            <th class="pb-3">{{ __('Posts') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Created') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($categories as $category)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $category->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $category->name }}</p>
                                    <p class="text-xs text-muted">{{ $category->slug }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $category->posts_count }}</td>
                                <td class="py-4 text-sm text-ink">{{ $category->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-sm text-ink">{{ \App\Support\FormatSettings::date($category->created_at) ?? '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.blog-categories.show', $category) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.blog-categories.edit', $category) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-blog-category-delete-{{ $category->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-blog-category-delete-{{ $category->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.blog-categories.destroy', $category) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this category?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No categories found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($categories as $category)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $category->name }}</p>
                                <p class="text-xs text-muted">{{ $category->slug }}</p>
                            </div>
                            <span class="badge">{{ $category->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <p class="mt-3 text-xs text-muted">{{ __('Posts:') }} {{ $category->posts_count }}</p>
                        <p class="mt-1 text-xs text-muted">{{ \App\Support\FormatSettings::date($category->created_at) ?? '-' }}</p>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.blog-categories.show', $category) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.blog-categories.edit', $category) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No categories found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-blog-category-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blog-categories.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected categories?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {{ __('You are about to remove') }} <span class="font-semibold text-ink" data-bulk-selected>0</span> {{ __('category(ies).') }}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-blog-categories" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blog-categories.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Blog Categories') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="blog_categories_file" :value="__('CSV File')" />
                        <input id="blog_categories_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $categories->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
