﻿@php
    $isEdit = isset($category) && $category;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Category Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Category Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $category->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                <p class="mt-2 text-xs text-muted">{{ __('Slug is auto-generated from the category name.') }}</p>
            </div>

            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Slug')" />
                    <p class="mt-2 text-sm text-muted">{{ $category->slug }}</p>
                </div>
            @endif
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $category->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $category->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>

            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created At')" />
                    <p class="mt-2 text-sm text-muted">{{ \App\Support\FormatSettings::dateTime($category->created_at) ?? '-' }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

