<x-admin-layout :title="__('Blog Posts')" :subtitle="__('Create, publish, and manage articles.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Blog Library') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Manage publishing content and editorial updates.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-blog-posts')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/blog-posts.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.blog-posts.create') }}" class="btn-primary">{{ __('Add Post') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.4fr,1fr,1fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search title, slug, or author') }}">
                </div>
                <div>
                    <label class="sr-only" for="category_id">{{ __('Category') }}</label>
                    <select id="category_id" name="category_id" class="input-field">
                        <option value="">{{ __('All categories') }}</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->id }}" @selected((string) $categoryId === (string) $category->id)>{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="bookmark">{{ __('Bookmark') }}</label>
                    <select id="bookmark" name="bookmark" class="input-field">
                        <option value="">{{ __('All bookmarks') }}</option>
                        <option value="bookmarked" @selected($bookmark === 'bookmarked')>{{ __('Bookmarked') }}</option>
                        <option value="unbookmarked" @selected($bookmark === 'unbookmarked')>{{ __('Standard') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="published_desc" @selected($sort === 'published_desc')>{{ __('Published (Newest)') }}</option>
                        <option value="published_asc" @selected($sort === 'published_asc')>{{ __('Published (Oldest)') }}</option>
                        <option value="title_asc" @selected($sort === 'title_asc')>{{ __('Title (A-Z)') }}</option>
                        <option value="title_desc" @selected($sort === 'title_desc')>{{ __('Title (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Created (Newest)') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Created (Oldest)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.blog-posts.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="blog-posts-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Post Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing :count of :total posts.', ['count' => $posts->count(), 'total' => $posts->total()]) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.blog-posts.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-blog-post-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm table-fixed">
                    <colgroup>
                        <col class="w-10">
                        <col class="w-[35%]">
                        <col>
                        <col>
                        <col>
                        <col>
                        <col>
                        <col class="w-[180px]">
                    </colgroup>
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Post') }}</th>
                            <th class="pb-3">{{ __('Category') }}</th>
                            <th class="pb-3">{{ __('Author') }}</th>
                            <th class="pb-3">{{ __('Published') }}</th>
                            <th class="pb-3">{{ __('Bookmark') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($posts as $post)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $post->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <div class="flex items-center gap-3 min-w-0">
                                        <div class="h-10 w-10 shrink-0 overflow-hidden rounded-xl border border-border bg-surface-2/80">
                                            @if ($post->image)
                                                <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="h-full w-full object-cover">
                                            @else
                                                <img src="{{ asset('images/placeholder-media.svg') }}" alt="{{ __('Placeholder image') }}" class="h-full w-full object-cover">
                                            @endif
                                        </div>
                                        <div class="min-w-0">
                                            <p class="font-semibold text-ink truncate">{{ $post->title }}</p>
                                            <p class="text-xs text-muted truncate">{{ $post->slug }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 text-sm text-ink whitespace-nowrap">{{ $post->category?->name ?? __('Unassigned') }}</td>
                                <td class="py-4 text-sm text-ink whitespace-nowrap truncate max-w-30">{{ $post->author_name ?: __('Not set') }}</td>
                                <td class="py-4 text-sm text-ink whitespace-nowrap">{{ \App\Support\FormatSettings::date($post->published_at) ?? '-' }}</td>
                                <td class="py-4 text-sm text-ink whitespace-nowrap">{{ $post->is_bookmarked ? __('Bookmarked') : __('Standard') }}</td>
                                <td class="py-4 text-sm text-ink whitespace-nowrap">{{ $post->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.blog-posts.show', $post) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.blog-posts.edit', $post) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-blog-post-delete-{{ $post->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-blog-post-delete-{{ $post->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.blog-posts.destroy', $post) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this post?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="py-6 text-center text-sm text-muted">{{ __('No blog posts found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($posts as $post)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div class="flex items-center gap-3">
                                <div class="h-10 w-10 overflow-hidden rounded-xl border border-border bg-surface-2/80">
                                    @if ($post->image)
                                        <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="h-full w-full object-cover">
                                    @else
                                        <img src="{{ asset('images/placeholder-media.svg') }}" alt="{{ __('Placeholder image') }}" class="h-full w-full object-cover">
                                    @endif
                                </div>
                                <div>
                                    <p class="font-semibold text-ink">{{ $post->title }}</p>
                                    <p class="text-xs text-muted">{{ $post->category?->name ?? __('Unassigned') }}</p>
                                </div>
                            </div>
                            <span class="badge">{{ $post->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-xs text-muted">{{ __('Published:') }} {{ \App\Support\FormatSettings::date($post->published_at) ?? '-' }}</div>
                        <div class="mt-1 text-xs text-muted">{{ __('Bookmark:') }} {{ $post->is_bookmarked ? __('Bookmarked') : __('Standard') }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.blog-posts.show', $post) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.blog-posts.edit', $post) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No blog posts found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-blog-post-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blog-posts.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected blog posts?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {{ __('You are about to remove') }} <span class="font-semibold text-ink" data-bulk-selected>0</span> {{ __('post(s).') }}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-blog-posts" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blog-posts.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Blog Posts') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="blog_posts_file" :value="__('CSV File')" />
                        <input id="blog_posts_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $posts->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
