@php
    $isEdit = isset($post) && $post;
    $tagsValue = old('tags', $isEdit ? implode(', ', $post->tags ?? []) : '');
    $publishedValue = old(
        'published_at',
        $isEdit ? (optional($post->published_at)->format('Y-m-d\\TH:i') ?? '') : now()->format('Y-m-d\\TH:i')
    );
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Post Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div class="flex items-center gap-4">
                <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                    @if ($isEdit && $post->image)
                        <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="h-full w-full object-cover">
                    @else
                        <img src="{{ asset('images/placeholder-media.svg') }}" alt="{{ __('Placeholder image') }}" class="h-full w-full object-cover">
                    @endif
                </div>
                <div>
                    <x-input-label for="image" :value="__('Featured Image')" />
                    <input id="image" name="image" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                    <p class="mt-2 text-xs text-muted">{{ __('JPG, JPEG, PNG, or WEBP. Max 10MB.') }}</p>
                    <x-input-error :messages="$errors->get('image')" class="mt-2" />
                </div>
            </div>

            <div>
                <x-input-label for="title" :value="__('Title')" />
                <x-text-input id="title" name="title" type="text" class="mt-1" :value="old('title', $isEdit ? $post->title : '')" required />
                <x-input-error :messages="$errors->get('title')" class="mt-2" />
                <p class="mt-2 text-xs text-muted">{{ __('Slug is auto-generated from the title.') }}</p>
            </div>

            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Slug')" />
                    <p class="mt-2 text-sm text-muted">{{ $post->slug }}</p>
                </div>
            @endif

            <div>
                <x-input-label for="author_name" :value="__('Author')" />
                <x-text-input id="author_name" name="author_name" type="text" class="mt-1" :value="old('author_name', $isEdit ? $post->author_name : '')" placeholder="{{ __('Staff Writer') }}" />
                <x-input-error :messages="$errors->get('author_name')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="category_id" :value="__('Category')" />
                <select id="category_id" name="category_id" class="input-field mt-1" required>
                    <option value="">{{ __('Select category') }}</option>
                    @foreach ($categories as $category)
                        <option value="{{ $category->id }}" @selected((string) old('category_id', $isEdit ? $post->category_id : '') === (string) $category->id)>{{ $category->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('category_id')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="tags" :value="__('Tags')" />
                <x-text-input id="tags" name="tags" type="text" class="mt-1" :value="$tagsValue" placeholder="{{ __('events, tips, studio') }}" />
                <p class="mt-2 text-xs text-muted">{{ __('Separate tags with commas.') }}</p>
                <x-input-error :messages="$errors->get('tags')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="published_at" :value="__('Publish Date')" />
                <x-text-input id="published_at" name="published_at" type="datetime-local" class="mt-1" :value="$publishedValue" />
                <x-input-error :messages="$errors->get('published_at')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Content & Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="excerpt" :value="__('Excerpt')" />
                <textarea id="excerpt" name="excerpt" rows="4" class="input-field mt-1">{{ old('excerpt', $isEdit ? $post->excerpt : '') }}</textarea>
                <x-input-error :messages="$errors->get('excerpt')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="details" :value="__('Details')" />
                <textarea id="details" name="details" rows="7" class="input-field mt-1">{{ old('details', $isEdit ? $post->details : '') }}</textarea>
                <x-input-error :messages="$errors->get('details')" class="mt-2" />
            </div>

            <div class="flex flex-wrap items-center gap-6">
                <div>
                    <x-input-label :value="__('Bookmark')" />
                    <input type="hidden" name="is_bookmarked" value="0">
                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                        <input type="checkbox" name="is_bookmarked" value="1" class="peer sr-only" @checked((bool) old('is_bookmarked', $isEdit ? $post->is_bookmarked : false))>
                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                        </span>
                        <span>{{ old('is_bookmarked', $isEdit ? $post->is_bookmarked : false) ? __('Bookmarked') : __('Standard') }}</span>
                    </label>
                </div>
                <div>
                    <x-input-label :value="__('Status')" />
                    <input type="hidden" name="is_active" value="0">
                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                        <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $post->is_active : true))>
                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                        </span>
                        <span>{{ old('is_active', $isEdit ? $post->is_active : true) ? __('Active') : __('Inactive') }}</span>
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>
