<x-admin-layout :title="__('Blog Post Details')" :subtitle="__('Review content before publishing or sharing.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                        @if ($post->image)
                            <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="h-full w-full object-cover">
                        @else
                            <img src="{{ asset('images/placeholder-media.svg') }}" alt="{{ __('Placeholder image') }}" class="h-full w-full object-cover">
                        @endif
                    </div>
                    <div>
                        <p class="panel-heading">{{ __('Post') }}</p>
                        <h2 class="mt-2 text-xl font-semibold text-ink">{{ $post->title }}</h2>
                        <p class="mt-1 text-sm text-muted">{{ __('Slug:') }} {{ $post->slug }}</p>
                    </div>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.blog-posts.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.blog-posts.edit', $post) }}" class="btn-primary">{{ __('Edit Post') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Category') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $post->category?->name ?? __('Unassigned') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Author') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $post->author_name ?: __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Published') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($post->published_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $post->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Bookmark') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $post->is_bookmarked ? __('Bookmarked') : __('Standard') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Tags') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $post->tags ? implode(', ', $post->tags) : __('None') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('Excerpt') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $post->excerpt ?: __('No excerpt provided.') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('Details') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $post->details ?: __('No details provided.') }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
