<x-admin-layout :title="__('Fact Details')" :subtitle="__('Review statistics displayed on the site.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Fact') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $fact->fact }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Value:') }} {{ $fact->value }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.fact-stats.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.fact-stats.edit', $fact) }}" class="btn-primary">{{ __('Edit Fact') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $fact->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created By') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $fact->creator?->name ?? __('System') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($fact->created_at) ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
