@php
    $isEdit = isset($testimonial) && $testimonial;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Client Profile') }}</p>
        <div class="mt-4 grid gap-4">
            <div class="flex items-center gap-4">
                <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                    @if ($isEdit && $testimonial->client_image)
                        <img src="{{ asset('storage/' . $testimonial->client_image) }}" alt="{{ $testimonial->client_name }}" class="h-full w-full object-cover">
                    @else
                        <img src="{{ asset('images/placeholder-user.svg') }}" alt="{{ __('Placeholder avatar') }}" class="h-full w-full object-cover">
                    @endif
                </div>
                <div>
                    <x-input-label for="client_image" :value="__('Client Image')" />
                    <input id="client_image" name="client_image" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                    <p class="mt-2 text-xs text-muted">{{ __('JPG, JPEG, PNG, or WEBP. Max 10MB.') }}</p>
                    <x-input-error :messages="$errors->get('client_image')" class="mt-2" />
                </div>
            </div>

            <div>
                <x-input-label for="client_name" :value="__('Client Name')" />
                <x-text-input id="client_name" name="client_name" type="text" class="mt-1" :value="old('client_name', $isEdit ? $testimonial->client_name : '')" required />
                <x-input-error :messages="$errors->get('client_name')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="client_position" :value="__('Client Position')" />
                <x-text-input id="client_position" name="client_position" type="text" class="mt-1" :value="old('client_position', $isEdit ? $testimonial->client_position : '')" />
                <x-input-error :messages="$errors->get('client_position')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="rating" :value="__('Rating')" />
                <select id="rating" name="rating" class="input-field mt-1" required>
                    @for ($i = 5; $i >= 1; $i--)
                        <option value="{{ $i }}" @selected((int) old('rating', $isEdit ? $testimonial->rating : 5) === $i)>{{ $i }} / 5</option>
                    @endfor
                </select>
                <x-input-error :messages="$errors->get('rating')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Review & Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="review" :value="__('Review')" />
                <textarea id="review" name="review" rows="6" class="input-field mt-1" required>{{ old('review', $isEdit ? $testimonial->review : '') }}</textarea>
                <x-input-error :messages="$errors->get('review')" class="mt-2" />
            </div>

            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $testimonial->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $testimonial->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>

            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created By')" />
                    <p class="mt-2 text-sm text-muted">{{ $testimonial->creator?->name ?? __('System') }}</p>
                </div>
                <div>
                    <x-input-label :value="__('Created At')" />
                    <p class="mt-2 text-sm text-muted">{{ \App\Support\FormatSettings::dateTime($testimonial->created_at) ?? '-' }}</p>
                </div>
            @endif
        </div>
    </div>
</div>
