<x-admin-layout :title="__('Testimonial Details')" :subtitle="__('Review client feedback and rating.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                        @if ($testimonial->client_image)
                            <img src="{{ asset('storage/' . $testimonial->client_image) }}" alt="{{ $testimonial->client_name }}" class="h-full w-full object-cover">
                        @else
                            <img src="{{ asset('images/placeholder-user.svg') }}" alt="{{ __('Placeholder avatar') }}" class="h-full w-full object-cover">
                        @endif
                    </div>
                    <div>
                        <p class="panel-heading">{{ __('Client') }}</p>
                        <h2 class="mt-2 text-xl font-semibold text-ink">{{ $testimonial->client_name }}</h2>
                        <p class="mt-1 text-sm text-muted">{{ $testimonial->client_position ?: __('No position provided') }}</p>
                    </div>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.testimonials.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.testimonials.edit', $testimonial) }}" class="btn-primary">{{ __('Edit Testimonial') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Rating') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $testimonial->rating }} / 5</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $testimonial->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($testimonial->created_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('Review') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $testimonial->review }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
