@php
    $isEdit = isset($coupon) && $coupon;
    $selectedPlans = old('plans', $isEdit ? $coupon->plans->pluck('id')->all() : []);
    $selectedType = old('discount_type', $isEdit ? $coupon->discount_type : 'percent');
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Coupon Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Coupon Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $coupon->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="code" :value="__('Coupon Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1 uppercase tracking-widest" :value="old('code', $isEdit ? $coupon->code : '')" required />
                <p class="mt-2 text-xs text-muted">{{ __('Use letters, numbers, or dashes only.') }}</p>
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="discount_type" :value="__('Discount Type')" />
                    <select id="discount_type" name="discount_type" class="input-field mt-1" required>
                        <option value="percent" @selected($selectedType === 'percent')>{{ __('Percent') }}</option>
                        <option value="fixed" @selected($selectedType === 'fixed')>{{ __('Fixed Amount') }}</option>
                    </select>
                    <x-input-error :messages="$errors->get('discount_type')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="discount_value" :value="__('Discount Value')" />
                    <x-text-input id="discount_value" name="discount_value" type="number" step="0.01" min="0" class="mt-1" :value="old('discount_value', $isEdit ? $coupon->discount_value : '')" required />
                    <x-input-error :messages="$errors->get('discount_value')" class="mt-2" />
                </div>
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="min_amount" :value="__('Minimum Amount')" />
                    <x-text-input id="min_amount" name="min_amount" type="number" step="0.01" min="0" class="mt-1" :value="old('min_amount', $isEdit ? $coupon->min_amount : '')" />
                    <x-input-error :messages="$errors->get('min_amount')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="starts_at" :value="__('Start Date')" />
                    <x-text-input id="starts_at" name="starts_at" type="date" class="mt-1" :value="old('starts_at', $isEdit ? optional($coupon->starts_at)->format('Y-m-d') : '')" />
                    <x-input-error :messages="$errors->get('starts_at')" class="mt-2" />
                </div>
            </div>
            <div>
                <x-input-label for="ends_at" :value="__('End Date')" />
                <x-text-input id="ends_at" name="ends_at" type="date" class="mt-1" :value="old('ends_at', $isEdit ? optional($coupon->ends_at)->format('Y-m-d') : '')" />
                <x-input-error :messages="$errors->get('ends_at')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Plan Assignment') }}</p>
        <div class="mt-4 grid gap-2 text-sm text-muted sm:grid-cols-2">
            @forelse ($plans as $plan)
                <label class="inline-flex items-center gap-2">
                    <input type="checkbox" name="plans[]" value="{{ $plan->id }}" class="h-4 w-4 rounded border-border text-brand focus:ring-brand/40" @checked(in_array($plan->id, $selectedPlans, true))>
                    {{ $plan->name }}
                </label>
            @empty
                <p class="text-sm text-muted">{{ __('Create a plan before assigning coupons.') }}</p>
            @endforelse
        </div>
        @php
            $planErrors = array_merge($errors->get('plans'), $errors->get('plans.*'));
        @endphp
        <x-input-error :messages="$planErrors" class="mt-2" />
    </div>

    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4 flex flex-wrap gap-6">
            <div>
                <x-input-label :value="__('Active Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $coupon->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $coupon->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            <div>
                <x-input-label :value="__('New Users Only')" />
                <input type="hidden" name="new_users_only" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="new_users_only" value="1" class="peer sr-only" @checked((bool) old('new_users_only', $isEdit ? $coupon->new_users_only : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('new_users_only', $isEdit ? $coupon->new_users_only : false) ? __('Enabled') : __('Disabled') }}</span>
                </label>
            </div>
        </div>
    </div>
</div>
