<x-admin-layout :title="__('Coupon Details')" :subtitle="__('Review discount rules and eligible plans.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Coupon') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $coupon->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Code:') }} {{ $coupon->code }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.coupons.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.coupons.edit', $coupon) }}" class="btn-primary">{{ __('Edit Coupon') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Discount') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        {{ $coupon->discount_type === 'percent' ? $coupon->discount_value . '%' : \App\Support\FormatSettings::currency($coupon->discount_value) }}
                    </p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Minimum Amount') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::currency($coupon->min_amount) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Validity') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        {{ $coupon->starts_at ? \App\Support\FormatSettings::date($coupon->starts_at) : __('Anytime') }}
                        @if ($coupon->ends_at)
                            - {{ \App\Support\FormatSettings::date($coupon->ends_at) }}
                        @endif
                    </p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $coupon->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('New Users Only') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $coupon->new_users_only ? __('Enabled') : __('Disabled') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Plans Linked') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $coupon->plans->count() }} {{ __('plan(s)') }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Eligible Plans') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Plans that this coupon can be applied to.') }}</p>
                </div>
                <a href="{{ route('admin.plans.index') }}" class="btn-secondary">{{ __('Manage Plans') }}</a>
            </div>
            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($coupon->plans as $plan)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                        <p class="font-semibold text-ink">{{ $plan->name }}</p>
                        <p class="mt-1 text-xs text-muted">{{ $plan->price == 0 ? __('Free') : \App\Support\FormatSettings::currency($plan->price) }}</p>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/60 p-6 text-center text-sm text-muted">
                        {{ __('No plans assigned yet.') }}
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
