<x-admin-layout :title="__('Events')" :subtitle="__('Manage event timelines, privacy, and media pipelines.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Events') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Track upcoming shoots, celebrations, and client events.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-events')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/events.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.events.create') }}" class="btn-primary">{{ __('Add Event') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.4fr,1fr,1fr,1fr,auto] md:grid-cols-[1.4fr,1fr,1fr,1fr] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by event name or slug') }}">
                </div>
                <div>
                    <label class="sr-only" for="type">{{ __('Type') }}</label>
                    <select id="type" name="type" class="input-field">
                        <option value="">{{ __('All types') }}</option>
                        @foreach ($types as $type)
                            <option value="{{ $type }}" @selected($typeFilter === $type)>{{ $type }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="date_desc" @selected($sort === 'date_desc')>{{ __('Event Date (Newest)') }}</option>
                        <option value="date_asc" @selected($sort === 'date_asc')>{{ __('Event Date (Oldest)') }}</option>
                        <option value="name_asc" @selected($sort === 'name_asc')>{{ __('Name (A-Z)') }}</option>
                        <option value="name_desc" @selected($sort === 'name_desc')>{{ __('Name (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Created (Newest)') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Created (Oldest)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.events.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="events-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Event Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing :count of :total events.', ['count' => $events->count(), 'total' => $events->total()]) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <x-dropdown align="right" width="48" content-classes="p-2">
                        <x-slot name="trigger">
                            <button type="button" class="btn-secondary">{{ __('Export') }}</button>
                        </x-slot>
                        <x-slot name="content">
                            <div class="media-dropdown-list">
                                <a href="{{ route('admin.events.export', array_merge(request()->query(), ['format' => 'csv'])) }}" class="media-dropdown-item whitespace-nowrap">{{ __('Export CSV') }}</a>
                                <a href="{{ route('admin.events.export', array_merge(request()->query(), ['format' => 'xlsx'])) }}" class="media-dropdown-item whitespace-nowrap">{{ __('Export Excel') }}</a>
                                <a href="{{ route('admin.events.export', array_merge(request()->query(), ['format' => 'pdf'])) }}" class="media-dropdown-item whitespace-nowrap">{{ __('Export PDF') }}</a>
                            </div>
                        </x-slot>
                    </x-dropdown>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-event-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Event') }}</th>
                            <th class="pb-3">{{ __('Type') }}</th>
                            <th class="pb-3">{{ __('Expiry') }}</th>
                            <th class="pb-3">{{ __('Media') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($events as $event)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $event->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $event->name }}</p>
                                    <p class="text-xs text-muted">{{ \App\Support\FormatSettings::date($event->event_date) }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $event->type }}</td>
                                <td class="py-4 text-sm text-ink">
                                    {{ $event->expiry_date ? \App\Support\FormatSettings::date($event->expiry_date) : __('Not set') }}
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $event->media_count }}</td>
                                <td class="py-4">
                                    <span class="text-sm font-semibold text-ink">{{ $event->is_active ? __('Active') : __('Inactive') }}</span>
                                </td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.events.show', $event) }}" class="btn-secondary">{{ __('Upload') }}</a>
                                        <a href="{{ route('admin.events.edit', $event) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-event-delete-{{ $event->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-event-delete-{{ $event->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.events.destroy', $event) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete') }} "{{ $event->name }}"?</p>
                                                <p class="mt-2 text-sm text-muted">{!! __('This event and <strong class="text-ink">all :count photos/videos</strong> inside it will be <strong class="text-danger">permanently deleted</strong> from the system. This action cannot be undone.', ['count' => $event->media_count]) !!}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete Permanently') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No events found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($events as $event)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div class="flex items-center gap-3">
                                <span class="h-12 w-12 overflow-hidden rounded-xl border border-border bg-surface-2/80">
                                    @if ($event->coverMedia)
                                        <img src="{{ $event->coverMedia->preview_url }}" alt="{{ $event->name }}" class="h-full w-full object-cover">
                                    @else
                                        <img src="{{ asset('images/placeholder-media.svg') }}" alt="{{ __('Placeholder') }}" class="h-full w-full object-cover">
                                    @endif
                                </span>
                                <div>
                                    <p class="font-semibold text-ink">{{ $event->name }}</p>
                                    <p class="text-xs text-muted">{{ \App\Support\FormatSettings::date($event->event_date) }}</p>
                                </div>
                            </div>
                            <span class="badge">{{ $event->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-4 flex flex-wrap gap-2">
                            <span class="badge">{{ $event->type }}</span>
                            <span class="badge">{{ __('Media') }} {{ $event->media_count }}</span>
                        </div>
                        <p class="mt-3 text-xs text-muted">{{ __('Expiry:') }} {{ $event->expiry_date ? \App\Support\FormatSettings::date($event->expiry_date) : __('Not set') }}</p>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.events.show', $event) }}" class="btn-secondary">{{ __('Upload') }}</a>
                            <a href="{{ route('admin.events.edit', $event) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No events found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-event-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.events.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected events?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {!! __('You are about to <strong class="text-danger">permanently delete</strong>') !!} <span class="font-semibold text-ink" data-bulk-selected>0</span> {!! __('event(s) and <strong class="text-ink">all photos/videos</strong> inside them. This action cannot be undone.') !!}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete Permanently') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-events" :show="false" focusable>
                <form method="POST" action="{{ route('admin.events.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Events') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="events_file" :value="__('CSV File')" />
                        <input id="events_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $events->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
