<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>{{ __('Event Invoice') }} - {{ $event->name }}</title>
        <style>
            body {
                font-family: DejaVu Sans, Arial, sans-serif;
                font-size: 12px;
                color: #111827;
            }
            h1 {
                font-size: 20px;
                margin-bottom: 4px;
            }
            h2 {
                font-size: 14px;
                margin: 18px 0 8px;
            }
            p {
                margin: 0 0 6px;
                color: #4b5563;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 8px;
            }
            th,
            td {
                border: 1px solid #e5e7eb;
                padding: 8px 10px;
                text-align: left;
            }
            th {
                background: #f9fafb;
                font-size: 11px;
                text-transform: uppercase;
                letter-spacing: 0.12em;
                color: #6b7280;
            }
            .meta {
                display: flex;
                justify-content: space-between;
                align-items: flex-start;
                gap: 16px;
            }
            .badge {
                display: inline-block;
                padding: 2px 8px;
                border-radius: 999px;
                background: #e5e7eb;
                font-size: 10px;
                text-transform: uppercase;
                letter-spacing: 0.08em;
            }
        </style>
    </head>
    <body>
        <div class="meta">
            <div>
                <h1>{{ __('Event Invoice') }}</h1>
                <p>{{ __('Invoice') }} #{{ $invoiceNumber }}</p>
                <p>{{ __('Issued') }} {{ \App\Support\FormatSettings::dateTime($issuedAt) }}</p>
            </div>
            <div>
                <span class="badge">{{ $event->is_active ? __('Active') : __('Inactive') }}</span>
            </div>
        </div>

        <h2>{{ __('Event Details') }}</h2>
        <table>
            <tbody>
                <tr>
                    <th>{{ __('Event Name') }}</th>
                    <td>{{ $event->name }}</td>
                </tr>
                <tr>
                    <th>{{ __('Event Type') }}</th>
                    <td>{{ $event->type }}</td>
                </tr>
                <tr>
                    <th>{{ __('Event Date') }}</th>
                    <td>{{ \App\Support\FormatSettings::date($event->event_date) }}</td>
                </tr>
                <tr>
                    <th>{{ __('Expiry Date') }}</th>
                    <td>{{ $event->expiry_date ? \App\Support\FormatSettings::date($event->expiry_date) : __('Not set') }}</td>
                </tr>
                <tr>
                    <th>{{ __('Created By') }}</th>
                    <td>
                        {{ $event->createdBy?->name ?? __('N/A') }}
                        @if ($event->createdBy?->email)
                            ({{ $event->createdBy->email }})
                        @endif
                    </td>
                </tr>
            </tbody>
        </table>

        <h2>{{ __('Media Summary') }}</h2>
        <table>
            <thead>
                <tr>
                    <th>{{ __('Total Media') }}</th>
                    <th>{{ __('Images') }}</th>
                    <th>{{ __('Videos') }}</th>
                    <th>{{ __('Storage Used') }}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $mediaCounts['total'] }}</td>
                    <td>{{ $mediaCounts['images'] }}</td>
                    <td>{{ $mediaCounts['videos'] }}</td>
                    <td>{{ $storageUsed }}</td>
                </tr>
            </tbody>
        </table>
    </body>
</html>
