@php
    $isEdit = isset($event) && $event;
    $selectedType = old('type', $isEdit ? $event->type : null);
    $hashtagsValue = old('hashtags', $isEdit ? implode(', ', $event->hashtags ?? []) : '');
    $canSetWatermark = $canSetWatermark ?? false;
    $watermarkPositions = $watermarkPositions ?? config('events.media.watermark.positions', []);
    $watermarkImage = $watermarkImage ?? null;
    $watermarkDefaultPosition = $watermarkDefaultPosition ?? (config('events.media.watermark.position') ?? 'top_right');
    $selectedWatermarkPosition = old('watermark_position', $isEdit ? $event->watermark_position : '');
    $defaultWatermarkLabel = $watermarkPositions[$watermarkDefaultPosition] ?? $watermarkDefaultPosition;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Event Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Event Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $event->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="type" :value="__('Event Type')" />
                <select id="type" name="type" class="input-field mt-1" required>
                    <option value="">{{ __('Select type') }}</option>
                    @foreach ($types as $type)
                        <option value="{{ $type }}" @selected($selectedType === $type)>{{ $type }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('type')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="event_date" :value="__('Event Date')" />
                <x-text-input id="event_date" name="event_date" type="date" class="mt-1" :value="old('event_date', $isEdit ? optional($event->event_date)->format('Y-m-d') : '')" required />
                <x-input-error :messages="$errors->get('event_date')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="expiry_date" :value="__('Event Expiry Date')" />
                <x-text-input id="expiry_date" name="expiry_date" type="date" class="mt-1" :value="old('expiry_date', $isEdit ? optional($event->expiry_date)->format('Y-m-d') : '')" />
                <x-input-error :messages="$errors->get('expiry_date')" class="mt-2" />
            </div>
            <div class="lg:col-span-2">
                <x-input-label for="details" :value="__('Details')" />
                <textarea id="details" name="details" rows="5" class="input-field mt-1">{{ old('details', $isEdit ? $event->details : '') }}</textarea>
                <x-input-error :messages="$errors->get('details')" class="mt-2" />
            </div>
            <div class="lg:col-span-2">
                <x-input-label for="hashtags" :value="__('Hash Tags')" />
                <x-text-input id="hashtags" name="hashtags" type="text" class="mt-1" :value="$hashtagsValue" placeholder="{{ __('wedding, couple, studio') }}" />
                <p class="mt-2 text-xs text-muted">{{ __('Separate tags with commas. Slug is auto-generated from the event name.') }}</p>
                <x-input-error :messages="$errors->get('hashtags')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Privacy & Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('Notifications')" />
                <input type="hidden" name="notifications_enabled" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="notifications_enabled" value="1" class="peer sr-only" @checked((bool) old('notifications_enabled', $isEdit ? $event->notifications_enabled : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('notifications_enabled', $isEdit ? $event->notifications_enabled : true) ? __('Enabled') : __('Disabled') }}</span>
                </label>
            </div>
            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $event->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $event->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            <div>
                <x-input-label :value="__('Guest Upload')" />
                <input type="hidden" name="allow_guest_upload" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="allow_guest_upload" value="1" class="peer sr-only" @checked((bool) old('allow_guest_upload', $isEdit ? $event->allow_guest_upload : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('allow_guest_upload', $isEdit ? $event->allow_guest_upload : false) ? __('Allowed') : __('Not Allowed') }}</span>
                </label>
            </div>
            <div>
                <x-input-label :value="__('Allow Public Downloads')" />
                <input type="hidden" name="allow_public_downloads" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="allow_public_downloads" value="1" class="peer sr-only" @checked((bool) old('allow_public_downloads', $isEdit ? $event->allow_public_downloads : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('allow_public_downloads', $isEdit ? $event->allow_public_downloads : false) ? __('Enabled') : __('Disabled') }}</span>
                </label>
            </div>

            <div>
                <x-input-label :value="__('Guest Access Pin')" />
                <div class="relative mt-1">
                    <x-text-input id="guest_pin" name="guest_pin" type="text" class="pr-24" autocomplete="new-password" inputmode="numeric" pattern="[0-9]{4,8}" :value="old('guest_pin', $isEdit ? $event->guest_pin : '')" />
                    <button type="button" class="absolute inset-y-0 right-10 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="guest_pin" aria-label="{{ __('Toggle guest pin visibility') }}">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-pin-generate data-target="guest_pin" data-length="6" aria-label="{{ __('Generate guest pin') }}">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 12a9 9 0 1 1-9-9"></path>
                            <path d="M21 3v6h-6"></path>
                            <path d="M3 12a9 9 0 0 0 9 9"></path>
                        </svg>
                    </button>
                </div>
                <p class="mt-2 text-xs text-muted">{{ __('4 to 8 digits.') }}</p>
                <x-input-error :messages="$errors->get('guest_pin')" class="mt-2" />
            </div>
            <div>
                <x-input-label :value="__('Admin Pin')" />
                <div class="relative mt-1">
                    <x-text-input id="admin_pin" name="admin_pin" type="text" class="pr-24" autocomplete="new-password" inputmode="numeric" pattern="[0-9]{4,8}" :value="old('admin_pin', $isEdit ? $event->admin_pin : '')" />
                    <button type="button" class="absolute inset-y-0 right-10 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="admin_pin" aria-label="{{ __('Toggle admin pin visibility') }}">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-pin-generate data-target="admin_pin" data-length="6" aria-label="{{ __('Generate admin pin') }}">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 12a9 9 0 1 1-9-9"></path>
                            <path d="M21 3v6h-6"></path>
                            <path d="M3 12a9 9 0 0 0 9 9"></path>
                        </svg>
                    </button>
                </div>
                <p class="mt-2 text-xs text-muted">{{ __('4 to 8 digits.') }}</p>
                <x-input-error :messages="$errors->get('admin_pin')" class="mt-2" />
            </div>
        </div>
    </div>

    @if ($canSetWatermark)
        <div class="panel p-6">
            <p class="panel-heading">{{ __('Watermark') }}</p>
            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                <div>
                    <x-input-label for="watermark_position" :value="__('Watermark Position')" />
                    <select id="watermark_position" name="watermark_position" class="input-field mt-1">
                        <option value="">{{ __('Use system default') }} ({{ $defaultWatermarkLabel }})</option>
                        @foreach ($watermarkPositions as $value => $label)
                            <option value="{{ $value }}" @selected((string) $selectedWatermarkPosition === (string) $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                    <x-input-error :messages="$errors->get('watermark_position')" class="mt-2" />
                </div>
                <div class="flex items-center gap-4">
                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                        <img src="{{ $watermarkImage ? asset('storage/' . $watermarkImage) : asset('images/placeholder-media.svg') }}" alt="{{ __('Watermark image') }}" class="h-full w-full object-contain">
                    </div>
                    <div>
                        <x-input-label :value="__('Watermark Image')" />
                        <p class="mt-2 text-xs text-muted">{{ __('Uses the system watermark image.') }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif

</div>
