﻿<x-admin-layout :title="__('Extensions & Integrations')" :subtitle="__('Connect analytics, pixels, and social sharing defaults.')">
    <div class="space-y-6">
        <div class="panel p-6" data-tab-group data-tab-storage="extensions-tab">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Integration Center') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Configure tracking and social share metadata.') }}</p>
                </div>
            </div>

            <div class="mt-5 flex flex-wrap gap-2">
                <button type="button" class="btn-secondary" data-tab-button="analytics">{{ __('Analytics') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="adsense">{{ __('AdSense') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="facebook">{{ __('Meta Pixel') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="microsoft">{{ __('Microsoft Ads') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="social">{{ __('Social Share') }}</button>
            </div>

            <div class="mt-6 space-y-8">
                <div data-tab-panel="analytics">
                    <form method="POST" action="{{ route('admin.extensions.update', 'analytics') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Google Analytics') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Enable Google Analytics')" />
                                    <input type="hidden" name="google_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="google_enabled" value="1" class="peer sr-only" @checked((bool) old('google_enabled', $settings['analytics']['google_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('google_enabled', $settings['analytics']['google_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="google_measurement_id" :value="__('Measurement ID')" />
                                    <x-text-input id="google_measurement_id" name="google_measurement_id" type="text" class="mt-1" :value="old('google_measurement_id', $settings['analytics']['google_measurement_id'])" placeholder="G-XXXXXXX" />
                                    <x-input-error :messages="$errors->get('google_measurement_id')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Analytics') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="adsense">
                    <form method="POST" action="{{ route('admin.extensions.update', 'adsense') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Google AdSense') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Enable AdSense')" />
                                    <input type="hidden" name="adsense_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="adsense_enabled" value="1" class="peer sr-only" @checked((bool) old('adsense_enabled', $settings['adsense']['adsense_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('adsense_enabled', $settings['adsense']['adsense_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="adsense_client_id" :value="__('Publisher ID')" />
                                    <x-text-input id="adsense_client_id" name="adsense_client_id" type="text" class="mt-1" :value="old('adsense_client_id', $settings['adsense']['adsense_client_id'])" placeholder="ca-pub-XXXXXXXXXXXXXXX" />
                                    <x-input-error :messages="$errors->get('adsense_client_id')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save AdSense') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="facebook">
                    <form method="POST" action="{{ route('admin.extensions.update', 'facebook') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Meta Pixel') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Enable Meta Pixel')" />
                                    <input type="hidden" name="pixel_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="pixel_enabled" value="1" class="peer sr-only" @checked((bool) old('pixel_enabled', $settings['facebook']['pixel_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('pixel_enabled', $settings['facebook']['pixel_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="pixel_id" :value="__('Pixel ID')" />
                                    <x-text-input id="pixel_id" name="pixel_id" type="text" class="mt-1" :value="old('pixel_id', $settings['facebook']['pixel_id'])" placeholder="1234567890" />
                                    <x-input-error :messages="$errors->get('pixel_id')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Pixel') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="microsoft">
                    <form method="POST" action="{{ route('admin.extensions.update', 'microsoft') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Microsoft Ads (UET Tag)') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Enable Microsoft UET')" />
                                    <input type="hidden" name="uet_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="uet_enabled" value="1" class="peer sr-only" @checked((bool) old('uet_enabled', $settings['microsoft']['uet_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('uet_enabled', $settings['microsoft']['uet_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="uet_tag_id" :value="__('UET Tag ID')" />
                                    <x-text-input id="uet_tag_id" name="uet_tag_id" type="text" class="mt-1" :value="old('uet_tag_id', $settings['microsoft']['uet_tag_id'])" placeholder="00000000" />
                                    <x-input-error :messages="$errors->get('uet_tag_id')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Microsoft Ads') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="social">
                    <form method="POST" action="{{ route('admin.extensions.update', 'social') }}" enctype="multipart/form-data" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Open Graph Defaults') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('Enable Social Sharing Defaults')" />
                                    <input type="hidden" name="og_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="og_enabled" value="1" class="peer sr-only" @checked((bool) old('og_enabled', $settings['social']['og_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('og_enabled', $settings['social']['og_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="og_title" :value="__('OG Title')" />
                                    <x-text-input id="og_title" name="og_title" type="text" class="mt-1" :value="old('og_title', $settings['social']['og_title'])" placeholder="{{ __('Default share title') }}" />
                                    <x-input-error :messages="$errors->get('og_title')" class="mt-2" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="og_description" :value="__('OG Description')" />
                                    <textarea id="og_description" name="og_description" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('og_description', $settings['social']['og_description']) }}</textarea>
                                    <x-input-error :messages="$errors->get('og_description')" class="mt-2" />
                                </div>
                                <div class="flex items-center gap-4 lg:col-span-2">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['social']['og_image'] ? asset('storage/' . $settings['social']['og_image']) : asset('images/placeholder-media.svg') }}" alt="OG image" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="og_image" :value="__('OG Image')" />
                                        <input id="og_image" name="og_image" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <x-input-error :messages="$errors->get('og_image')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Social Share') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>

