<x-admin-layout :title="__('FAQ Details')" :subtitle="__('Review question content and visibility settings.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('FAQ') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $faq->question }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $faq->slug }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.faqs.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.faqs.edit', $faq) }}" class="btn-primary">{{ __('Edit FAQ') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Sort Order') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $faq->sort_order }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $faq->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $faq->updated_at ? \App\Support\FormatSettings::date($faq->updated_at) : '�' }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Answer') }}</p>
            <p class="mt-3 text-sm text-muted">{{ $faq->answer }}</p>
        </div>
    </div>
</x-admin-layout>
