<x-admin-layout :title="__('P/L Book')" :subtitle="__('Profit and Loss Financial Report')">
    <div class="space-y-6">

        {{-- Filters --}}
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Financial Overview') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Revenue, refunds, and profit breakdown.') }}</p>
                </div>
                <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
            </div>

            <div class="mt-5 flex flex-wrap items-end gap-3">
                {{-- Year quick-select --}}
                @for ($y = now()->year - 2; $y <= now()->year; $y++)
                    <a href="{{ route('admin.financial-report.index', ['year' => $y]) }}"
                       @class(['btn-secondary', 'ring-2 ring-brand/50 bg-brand/5' => $year === $y && !$startDate])>
                        {{ $y }}
                    </a>
                @endfor

                {{-- Custom date range --}}
                <form method="get" action="{{ route('admin.financial-report.index') }}" class="flex flex-wrap items-end gap-3">
                    <div>
                        <label class="text-xs font-medium text-muted" for="start_date">{{ __('From') }}</label>
                        <input type="date" id="start_date" name="start_date" value="{{ $startDate }}" class="input-field mt-1">
                    </div>
                    <div>
                        <label class="text-xs font-medium text-muted" for="end_date">{{ __('To') }}</label>
                        <input type="date" id="end_date" name="end_date" value="{{ $endDate }}" class="input-field mt-1">
                    </div>
                    <button type="submit" class="btn-secondary">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.financial-report.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </form>
            </div>
        </div>

        {{-- Summary Cards --}}
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-5">
            <div class="panel p-5">
                <p class="text-xs font-semibold text-muted">{{ __('Total Revenue') }}</p>
                <p class="mt-2 text-2xl font-bold text-emerald-600">{{ $currencySymbol }}{{ number_format($totalRevenue, 2) }}</p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold text-muted">{{ __('Refunds') }}</p>
                <p class="mt-2 text-2xl font-bold text-red-500">{{ $currencySymbol }}{{ number_format($totalRefunds, 2) }}</p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold text-muted">{{ __('Net Revenue') }}</p>
                <p class="mt-2 text-2xl font-bold {{ $netRevenue >= 0 ? 'text-emerald-600' : 'text-red-500' }}">{{ $currencySymbol }}{{ number_format($netRevenue, 2) }}</p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold text-muted">{{ __('Orders') }}</p>
                <p class="mt-2 text-2xl font-bold text-ink">{{ number_format($totalOrders) }}</p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold text-muted">{{ __('Avg Order') }}</p>
                <p class="mt-2 text-2xl font-bold text-ink">{{ $currencySymbol }}{{ number_format($avgOrderValue, 2) }}</p>
            </div>
        </div>

        {{-- Charts --}}
        <div class="grid gap-6 md:grid-cols-2">
            <div class="panel p-6">
                <p class="text-sm font-semibold text-ink mb-4">{{ __('Monthly Revenue vs Refunds') }}</p>
                <div id="revenue-bar-chart" class="w-full h-64"></div>
            </div>
            <div class="panel p-6">
                <p class="text-sm font-semibold text-ink mb-4">{{ __('Revenue by Plan') }}</p>
                @if(count($revenueByPlan) > 0)
                    <div id="plan-donut-chart" class="w-full h-64"></div>
                @else
                    <p class="text-sm text-muted py-10 text-center">{{ __('No data for this period.') }}</p>
                @endif
            </div>
        </div>

        {{-- Monthly P&L Table --}}
        <div class="panel p-6">
            <p class="panel-heading mb-4">{{ __('Monthly Breakdown') }}</p>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs text-muted">
                        <tr>
                            <th class="pb-3">{{ __('Month') }}</th>
                            <th class="pb-3 text-right">{{ __('Revenue') }}</th>
                            <th class="pb-3 text-right">{{ __('Refunds') }}</th>
                            <th class="pb-3 text-right">{{ __('Net') }}</th>
                            <th class="pb-3 text-right">{{ __('Orders') }}</th>
                            <th class="pb-3 text-right">{{ __('Avg Order') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @foreach ($months as $month)
                            <tr class="{{ $month['revenue'] == 0 && $month['refunds'] == 0 ? 'text-muted/60' : '' }}">
                                <td class="py-3 font-medium">{{ $month['label'] }}</td>
                                <td class="py-3 text-right text-emerald-600">{{ $currencySymbol }}{{ number_format($month['revenue'], 2) }}</td>
                                <td class="py-3 text-right text-red-500">{{ $currencySymbol }}{{ number_format($month['refunds'], 2) }}</td>
                                <td class="py-3 text-right font-medium {{ $month['net'] >= 0 ? 'text-emerald-600' : 'text-red-500' }}">{{ $currencySymbol }}{{ number_format($month['net'], 2) }}</td>
                                <td class="py-3 text-right">{{ $month['orders'] }}</td>
                                <td class="py-3 text-right">{{ $currencySymbol }}{{ number_format($month['avg'], 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="border-t-2 border-border font-semibold">
                        <tr>
                            <td class="py-3">{{ __('Total') }}</td>
                            <td class="py-3 text-right text-emerald-600">{{ $currencySymbol }}{{ number_format($totalRevenue, 2) }}</td>
                            <td class="py-3 text-right text-red-500">{{ $currencySymbol }}{{ number_format($totalRefunds, 2) }}</td>
                            <td class="py-3 text-right {{ $netRevenue >= 0 ? 'text-emerald-600' : 'text-red-500' }}">{{ $currencySymbol }}{{ number_format($netRevenue, 2) }}</td>
                            <td class="py-3 text-right">{{ number_format($totalOrders) }}</td>
                            <td class="py-3 text-right">{{ $currencySymbol }}{{ number_format($avgOrderValue, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Monthly Revenue vs Refunds bar chart
            const monthLabels = @json(array_map(fn ($m) => $m['short'], $months));
            const revenueData = @json(array_map(fn ($m) => $m['revenue'], $months));
            const refundData = @json(array_map(fn ($m) => $m['refunds'], $months));

            new ApexCharts(document.querySelector('#revenue-bar-chart'), {
                series: [
                    { name: 'Revenue', data: revenueData },
                    { name: 'Refunds', data: refundData }
                ],
                chart: {
                    type: 'bar',
                    height: 250,
                    toolbar: { show: false },
                    fontFamily: 'inherit'
                },
                plotOptions: {
                    bar: { borderRadius: 4, columnWidth: '60%' }
                },
                xaxis: { categories: monthLabels },
                colors: ['#10b981', '#ef4444'],
                dataLabels: { enabled: false },
                theme: { mode: document.documentElement.classList.contains('dark') ? 'dark' : 'light' }
            }).render();

            // Revenue by Plan donut
            @if(count($revenueByPlan) > 0)
            new ApexCharts(document.querySelector('#plan-donut-chart'), {
                series: @json(array_column($revenueByPlan, 'value')),
                labels: @json(array_column($revenueByPlan, 'label')),
                chart: {
                    type: 'donut',
                    height: 250,
                    toolbar: { show: false },
                    fontFamily: 'inherit'
                },
                legend: { position: 'bottom' },
                colors: ['#3b82f6', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#ec4899', '#14b8a6', '#f97316'],
                dataLabels: { enabled: false },
                theme: { mode: document.documentElement.classList.contains('dark') ? 'dark' : 'light' }
            }).render();
            @endif
        });
    </script>
    @endpush
</x-admin-layout>
