<x-admin-layout :title="__('Frontend Settings')" :subtitle="__('Manage content for built-in pages')">

    <div class="space-y-8">
        <div>
            <p class="panel-heading mb-4">{{ __('Page Settings') }}</p>
            <p class="text-sm text-muted mb-6">{{ __('Edit the content displayed on your website\'s built-in pages. The design stays the same — only the text changes.') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @foreach([
                    ['type' => 'about', 'title' => __('About Us'), 'desc' => __('Hero text, stats, story section, and value cards.'), 'icon' => '<circle cx="12" cy="12" r="10"/><path d="M12 16v-4"/><path d="M12 8h.01"/>'],
                    ['type' => 'contact', 'title' => __('Contact Us'), 'desc' => __('Hero text, support info, and quick stats.'), 'icon' => '<path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>'],
                    ['type' => 'privacy_policy', 'title' => __('Privacy Policy'), 'desc' => __('Header, privacy sections, and bottom paragraphs.'), 'icon' => '<path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/><path d="m9 12 2 2 4-4"/>'],
                    ['type' => 'terms', 'title' => __('Terms of Service'), 'desc' => __('Header and numbered legal sections.'), 'icon' => '<path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"/><polyline points="14 2 14 8 20 8"/><line x1="16" x2="8" y1="13" y2="13"/><line x1="16" x2="8" y1="17" y2="17"/>'],
                    ['type' => 'cookie_policy', 'title' => __('Cookie Policy'), 'desc' => __('Header, cookie types, and management section.'), 'icon' => '<circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/>'],
                ] as $card)
                <a href="{{ route('admin.frontend-settings.edit', $card['type']) }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">Frontend</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">{!! $card['icon'] !!}</svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ $card['title'] }}</p>
                        <p class="mt-1 text-sm text-muted">{{ $card['desc'] }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endforeach
            </div>
        </div>
    </div>

</x-admin-layout>
