{{-- Hero Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Hero Section') }}</p>
    <div class="mt-4 grid gap-4">
        <div>
            <x-input-label for="badge_text" :value="__('Badge Text')" />
            <x-text-input id="badge_text" name="content[badge_text]" type="text" class="mt-1" :value="old('content.badge_text', $content['badge_text'] ?? '')" />
            <x-input-error :messages="$errors->get('content.badge_text')" class="mt-2" />
        </div>
        <div class="grid gap-4 sm:grid-cols-2">
            <div>
                <x-input-label for="hero_title" :value="__('Title (Line 1)')" />
                <x-text-input id="hero_title" name="content[hero_title]" type="text" class="mt-1" :value="old('content.hero_title', $content['hero_title'] ?? '')" />
            </div>
            <div>
                <x-input-label for="hero_title_highlight" :value="__('Title (Highlighted)')" />
                <x-text-input id="hero_title_highlight" name="content[hero_title_highlight]" type="text" class="mt-1" :value="old('content.hero_title_highlight', $content['hero_title_highlight'] ?? '')" />
            </div>
        </div>
        <div>
            <x-input-label for="hero_description" :value="__('Description')" />
            <textarea id="hero_description" name="content[hero_description]" rows="3" class="input-field mt-1">{{ old('content.hero_description', $content['hero_description'] ?? '') }}</textarea>
        </div>
    </div>
</div>

{{-- Stats Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Stats Section') }}</p>
    <p class="mt-1 text-sm text-muted">{{ __('Edit the 4 stats displayed on the about page.') }}</p>
    <div class="mt-4 grid gap-4">
        @for($i = 0; $i < 4; $i++)
        <div class="grid gap-4 sm:grid-cols-2">
            <div>
                <x-input-label :value="__('Stat ' . ($i + 1) . ' Label')" />
                <x-text-input name="content[stats][{{ $i }}][label]" type="text" class="mt-1" :value="old('content.stats.' . $i . '.label', $content['stats'][$i]['label'] ?? '')" />
            </div>
            <div>
                <x-input-label :value="__('Stat ' . ($i + 1) . ' Value')" />
                <x-text-input name="content[stats][{{ $i }}][value]" type="text" class="mt-1" :value="old('content.stats.' . $i . '.value', $content['stats'][$i]['value'] ?? '')" />
            </div>
        </div>
        @endfor
    </div>
</div>

{{-- Story Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Story Section') }}</p>
    <div class="mt-4 grid gap-4">
        <div>
            <x-input-label for="story_title" :value="__('Story Title')" />
            <x-text-input id="story_title" name="content[story_title]" type="text" class="mt-1" :value="old('content.story_title', $content['story_title'] ?? '')" />
        </div>
        <div>
            <x-input-label for="story_paragraph_1" :value="__('Story Paragraph 1')" />
            <textarea id="story_paragraph_1" name="content[story_paragraph_1]" rows="4" class="input-field mt-1">{{ old('content.story_paragraph_1', $content['story_paragraph_1'] ?? '') }}</textarea>
        </div>
        <div>
            <x-input-label for="story_paragraph_2" :value="__('Story Paragraph 2')" />
            <textarea id="story_paragraph_2" name="content[story_paragraph_2]" rows="4" class="input-field mt-1">{{ old('content.story_paragraph_2', $content['story_paragraph_2'] ?? '') }}</textarea>
        </div>
    </div>
</div>

{{-- Value Cards --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Value Cards') }}</p>
    <div class="mt-4 grid gap-6">
        <div class="grid gap-4">
            <x-input-label :value="__('Card 1')" />
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-text-input name="content[card_1_title]" type="text" class="mt-1" placeholder="{{ __('Title') }}" :value="old('content.card_1_title', $content['card_1_title'] ?? '')" />
                </div>
                <div>
                    <x-text-input name="content[card_1_description]" type="text" class="mt-1" placeholder="{{ __('Description') }}" :value="old('content.card_1_description', $content['card_1_description'] ?? '')" />
                </div>
            </div>
        </div>
        <div class="grid gap-4">
            <x-input-label :value="__('Card 2')" />
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-text-input name="content[card_2_title]" type="text" class="mt-1" placeholder="{{ __('Title') }}" :value="old('content.card_2_title', $content['card_2_title'] ?? '')" />
                </div>
                <div>
                    <x-text-input name="content[card_2_description]" type="text" class="mt-1" placeholder="{{ __('Description') }}" :value="old('content.card_2_description', $content['card_2_description'] ?? '')" />
                </div>
            </div>
        </div>
    </div>
</div>
