{{-- Hero Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Hero Section') }}</p>
    <div class="mt-4 grid gap-4">
        <div>
            <x-input-label for="badge_text" :value="__('Badge Text')" />
            <x-text-input id="badge_text" name="content[badge_text]" type="text" class="mt-1" :value="old('content.badge_text', $content['badge_text'] ?? '')" />
        </div>
        <div class="grid gap-4 sm:grid-cols-2">
            <div>
                <x-input-label for="hero_title" :value="__('Title (Line 1)')" />
                <x-text-input id="hero_title" name="content[hero_title]" type="text" class="mt-1" :value="old('content.hero_title', $content['hero_title'] ?? '')" />
            </div>
            <div>
                <x-input-label for="hero_title_highlight" :value="__('Title (Highlighted)')" />
                <x-text-input id="hero_title_highlight" name="content[hero_title_highlight]" type="text" class="mt-1" :value="old('content.hero_title_highlight', $content['hero_title_highlight'] ?? '')" />
            </div>
        </div>
        <div>
            <x-input-label for="hero_description" :value="__('Description')" />
            <textarea id="hero_description" name="content[hero_description]" rows="3" class="input-field mt-1">{{ old('content.hero_description', $content['hero_description'] ?? '') }}</textarea>
        </div>
    </div>
</div>

{{-- Info Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Support Info') }}</p>
    <div class="mt-4 grid gap-4 sm:grid-cols-2">
        <div>
            <x-input-label for="support_label" :value="__('Support Card Label')" />
            <x-text-input id="support_label" name="content[support_label]" type="text" class="mt-1" :value="old('content.support_label', $content['support_label'] ?? '')" />
        </div>
        <div>
            <x-input-label for="support_text" :value="__('Support Card Text')" />
            <x-text-input id="support_text" name="content[support_text]" type="text" class="mt-1" :value="old('content.support_text', $content['support_text'] ?? '')" />
        </div>
    </div>
</div>

{{-- Quick Stats --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Quick Stats') }}</p>
    <div class="mt-4 grid gap-4 sm:grid-cols-2">
        <div>
            <x-input-label for="response_label" :value="__('Response Label')" />
            <x-text-input id="response_label" name="content[response_label]" type="text" class="mt-1" :value="old('content.response_label', $content['response_label'] ?? '')" />
        </div>
        <div>
            <x-input-label for="response_value" :value="__('Response Value')" />
            <x-text-input id="response_value" name="content[response_value]" type="text" class="mt-1" :value="old('content.response_value', $content['response_value'] ?? '')" />
        </div>
        <div>
            <x-input-label for="sales_label" :value="__('Sales Label')" />
            <x-text-input id="sales_label" name="content[sales_label]" type="text" class="mt-1" :value="old('content.sales_label', $content['sales_label'] ?? '')" />
        </div>
        <div>
            <x-input-label for="sales_value" :value="__('Sales Value')" />
            <x-text-input id="sales_value" name="content[sales_value]" type="text" class="mt-1" :value="old('content.sales_value', $content['sales_value'] ?? '')" />
        </div>
    </div>
</div>
