{{-- Header Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Header') }}</p>
    <div class="mt-4 grid gap-4">
        <div class="grid gap-4 sm:grid-cols-3">
            <div>
                <x-input-label for="title" :value="__('Title')" />
                <x-text-input id="title" name="content[title]" type="text" class="mt-1" :value="old('content.title', $content['title'] ?? '')" />
            </div>
            <div>
                <x-input-label for="title_highlight" :value="__('Title (Highlighted)')" />
                <x-text-input id="title_highlight" name="content[title_highlight]" type="text" class="mt-1" :value="old('content.title_highlight', $content['title_highlight'] ?? '')" />
            </div>
            <div>
                <x-input-label for="last_updated" :value="__('Last Updated')" />
                <x-text-input id="last_updated" name="content[last_updated]" type="text" class="mt-1" :value="old('content.last_updated', $content['last_updated'] ?? '')" />
            </div>
        </div>
        <div>
            <x-input-label for="intro_text" :value="__('Introduction Text')" />
            <textarea id="intro_text" name="content[intro_text]" rows="3" class="input-field mt-1">{{ old('content.intro_text', $content['intro_text'] ?? '') }}</textarea>
        </div>
    </div>
</div>

{{-- Cookie Types --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Cookie Types') }}</p>
    <p class="mt-1 text-sm text-muted">{{ __('Edit the 3 cookie type cards.') }}</p>
    <div class="mt-4 space-y-6">
        @for($i = 0; $i < 3; $i++)
        <div class="rounded-xl border border-border/50 p-4 space-y-3">
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label :value="__('Cookie Type ' . ($i + 1) . ' Title')" />
                    <x-text-input name="content[cookie_types][{{ $i }}][title]" type="text" class="mt-1" :value="old('content.cookie_types.' . $i . '.title', $content['cookie_types'][$i]['title'] ?? '')" />
                </div>
                <div>
                    <x-input-label :value="__('Priority')" />
                    <select name="content[cookie_types][{{ $i }}][priority]" class="input-field mt-1">
                        <option value="Mandatory" @selected(old('content.cookie_types.' . $i . '.priority', $content['cookie_types'][$i]['priority'] ?? '') === 'Mandatory')>{{ __('Mandatory') }}</option>
                        <option value="Optional" @selected(old('content.cookie_types.' . $i . '.priority', $content['cookie_types'][$i]['priority'] ?? '') === 'Optional')>{{ __('Optional') }}</option>
                    </select>
                </div>
            </div>
            <div>
                <x-input-label :value="__('Description')" />
                <textarea name="content[cookie_types][{{ $i }}][description]" rows="2" class="input-field mt-1">{{ old('content.cookie_types.' . $i . '.description', $content['cookie_types'][$i]['description'] ?? '') }}</textarea>
            </div>
        </div>
        @endfor
    </div>
</div>

{{-- Cookie Management --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Cookie Management') }}</p>
    <div class="mt-4 grid gap-4">
        <div>
            <x-input-label for="manage_title" :value="__('Section Title')" />
            <x-text-input id="manage_title" name="content[manage_title]" type="text" class="mt-1" :value="old('content.manage_title', $content['manage_title'] ?? '')" />
        </div>
        <div>
            <x-input-label for="manage_text" :value="__('Section Text')" />
            <textarea id="manage_text" name="content[manage_text]" rows="3" class="input-field mt-1">{{ old('content.manage_text', $content['manage_text'] ?? '') }}</textarea>
        </div>
    </div>
</div>
