{{-- Header Section --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Header') }}</p>
    <div class="mt-4 grid gap-4">
        <div class="grid gap-4 sm:grid-cols-3">
            <div>
                <x-input-label for="title" :value="__('Title')" />
                <x-text-input id="title" name="content[title]" type="text" class="mt-1" :value="old('content.title', $content['title'] ?? '')" />
            </div>
            <div>
                <x-input-label for="title_highlight" :value="__('Title (Highlighted)')" />
                <x-text-input id="title_highlight" name="content[title_highlight]" type="text" class="mt-1" :value="old('content.title_highlight', $content['title_highlight'] ?? '')" />
            </div>
            <div>
                <x-input-label for="last_updated" :value="__('Last Updated')" />
                <x-text-input id="last_updated" name="content[last_updated]" type="text" class="mt-1" :value="old('content.last_updated', $content['last_updated'] ?? '')" />
            </div>
        </div>
        <div>
            <x-input-label for="subtitle" :value="__('Subtitle')" />
            <textarea id="subtitle" name="content[subtitle]" rows="2" class="input-field mt-1">{{ old('content.subtitle', $content['subtitle'] ?? '') }}</textarea>
        </div>
    </div>
</div>

{{-- Privacy Sections --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Privacy Sections') }}</p>
    <p class="mt-1 text-sm text-muted">{{ __('Edit the 4 privacy policy cards.') }}</p>
    <div class="mt-4 space-y-6">
        @for($i = 0; $i < 4; $i++)
        <div class="rounded-xl border border-border/50 p-4 space-y-3">
            <div>
                <x-input-label :value="__('Section ' . ($i + 1) . ' Title')" />
                <x-text-input name="content[sections][{{ $i }}][title]" type="text" class="mt-1" :value="old('content.sections.' . $i . '.title', $content['sections'][$i]['title'] ?? '')" />
            </div>
            <div>
                <x-input-label :value="__('Section ' . ($i + 1) . ' Content')" />
                <textarea name="content[sections][{{ $i }}][content]" rows="3" class="input-field mt-1">{{ old('content.sections.' . $i . '.content', $content['sections'][$i]['content'] ?? '') }}</textarea>
            </div>
        </div>
        @endfor
    </div>
</div>

{{-- Bottom Paragraphs --}}
<div class="panel p-6">
    <p class="panel-heading">{{ __('Bottom Section') }}</p>
    <div class="mt-4 grid gap-4">
        <div>
            <x-input-label for="bottom_paragraph_1" :value="__('Paragraph 1')" />
            <textarea id="bottom_paragraph_1" name="content[bottom_paragraph_1]" rows="3" class="input-field mt-1">{{ old('content.bottom_paragraph_1', $content['bottom_paragraph_1'] ?? '') }}</textarea>
        </div>
        <div>
            <x-input-label for="bottom_paragraph_2" :value="__('Paragraph 2')" />
            <textarea id="bottom_paragraph_2" name="content[bottom_paragraph_2]" rows="3" class="input-field mt-1">{{ old('content.bottom_paragraph_2', $content['bottom_paragraph_2'] ?? '') }}</textarea>
        </div>
    </div>
</div>
