﻿@php
    $isEdit = isset($city) && $city;
    $selectedState = old('state_id', $isEdit ? $city->state_id : null);
    $selectedCountry = old('country_id', $isEdit ? optional($city->state)->country_id : null);
@endphp

<div class="grid gap-6 lg:grid-cols-2" data-location-scope>
    <div class="panel p-6">
        <p class="panel-heading">{{ __('City Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="country_id" :value="__('Country')" />
                <select id="country_id" name="country_id" class="input-field mt-1" data-country-select>
                    <option value="">{{ __('Select country') }}</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @selected((string) $selectedCountry === (string) $country->id)>{{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <x-input-label for="state_id" :value="__('State')" />
                <select id="state_id" name="state_id" class="input-field mt-1" data-state-select required>
                    <option value="">{{ __('Select state') }}</option>
                    @foreach ($states as $state)
                        <option value="{{ $state->id }}" data-country-id="{{ $state->country_id }}" @selected((string) $selectedState === (string) $state->id)>{{ $state->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('state_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="name" :value="__('City Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $city->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4">
            <x-input-label :value="__('City Status')" />
            <input type="hidden" name="is_active" value="0">
            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $city->is_active : true))>
                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                </span>
                <span>{{ old('is_active', $isEdit ? $city->is_active : true) ? __('Active') : __('Inactive') }}</span>
            </label>
        </div>
    </div>
</div>

