﻿<x-admin-layout :title="__('City Details')" :subtitle="__('Review city information for operational accuracy.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('City') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $city->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('State') }}: {{ $city->state?->name ?? __('Not set') }}</p>
                    <p class="mt-1 text-sm text-muted">{{ __('Country') }}: {{ $city->state?->country?->name ?? __('Not set') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.cities.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.cities.edit', $city) }}" class="btn-primary">{{ __('Edit City') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $city->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-2">
                    <p class="panel-heading">{{ __('Linked Location') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        {{ $city->state?->name ?? __('State not set') }} / {{ $city->state?->country?->name ?? __('Country not set') }}
                    </p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Quick Actions') }}</p>
            <div class="mt-4 flex flex-wrap items-center gap-3">
                @if ($city->state_id)
                    <a href="{{ route('admin.states.show', $city->state_id) }}" class="btn-secondary">{{ __('View State') }}</a>
                @endif
                @if ($city->state?->country_id)
                    <a href="{{ route('admin.countries.show', $city->state->country_id) }}" class="btn-secondary">{{ __('View Country') }}</a>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
