﻿<x-admin-layout :title="__('Countries')" :subtitle="__('Manage country catalogs and auto-import states or cities when needed.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Locations') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Maintain country details for consistent location data.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-countries')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/countries.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.countries.create') }}" class="btn-primary">{{ __('Add Country') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">Search</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by name or ISO code') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">Status</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="name_asc" @selected($sort === 'name_asc')>{{ __('Name (A-Z)') }}</option>
                        <option value="name_desc" @selected($sort === 'name_desc')>{{ __('Name (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.countries.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="countries-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Country Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $countries->count() }} of {{ $countries->total() }} countries.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.countries.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-country-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Country') }}</th>
                            <th class="pb-3">{{ __('ISO Codes') }}</th>
                            <th class="pb-3">{{ __('States') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($countries as $country)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $country->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $country->name }}</p>
                                    <p class="text-xs text-muted">{{ __('Phone code') }}: {{ $country->phone_code ? '+' . $country->phone_code : __('Not set') }}</p>
                                </td>
                                <td class="py-4">
                                    <div class="flex flex-wrap gap-2">
                                        <span class="badge">ISO2 {{ $country->iso2 ?? 'N/A' }}</span>
                                        <span class="badge">ISO3 {{ $country->iso3 ?? 'N/A' }}</span>
                                    </div>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $country->states_count }}</td>
                                <td class="py-4">
                                    <span class="text-sm font-semibold text-ink">{{ $country->is_active ? __('Active') : __('Inactive') }}</span>
                                </td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.countries.show', $country) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.countries.edit', $country) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-country-delete-{{ $country->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-country-delete-{{ $country->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.countries.destroy', $country) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">Delete {{ $country->name }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No countries found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($countries as $country)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $country->name }}</p>
                                <p class="text-xs text-muted">{{ __('Phone code') }}: {{ $country->phone_code ? '+' . $country->phone_code : __('Not set') }}</p>
                            </div>
                            <span class="badge">{{ $country->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-4 flex flex-wrap gap-2">
                            <span class="badge">ISO2 {{ $country->iso2 ?? 'N/A' }}</span>
                            <span class="badge">ISO3 {{ $country->iso3 ?? 'N/A' }}</span>
                        </div>
                        <p class="mt-3 text-xs text-muted">{{ __('States') }}: {{ $country->states_count }}</p>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.countries.show', $country) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.countries.edit', $country) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No countries found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-country-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.countries.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected countries?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> country(ies).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-countries" :show="false" focusable>
                <form method="POST" action="{{ route('admin.countries.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Countries') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="country_file" :value="__('CSV File')" />
                        <input id="country_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $countries->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
