﻿@php
    $isEdit = isset($country) && $country;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Country Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Country Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $country->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="iso2" :value="__('ISO2 Code')" />
                <x-text-input id="iso2" name="iso2" type="text" class="mt-1" maxlength="2" :value="old('iso2', $isEdit ? $country->iso2 : '')" />
                <x-input-error :messages="$errors->get('iso2')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="iso3" :value="__('ISO3 Code')" />
                <x-text-input id="iso3" name="iso3" type="text" class="mt-1" maxlength="3" :value="old('iso3', $isEdit ? $country->iso3 : '')" />
                <x-input-error :messages="$errors->get('iso3')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="phone_code" :value="__('Phone Code')" />
                <x-text-input id="phone_code" name="phone_code" type="text" class="mt-1" inputmode="numeric" pattern="[0-9]+" :value="old('phone_code', $isEdit ? $country->phone_code : '')" placeholder="91" />
                <x-input-error :messages="$errors->get('phone_code')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status & Import') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $country->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $country->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            <div>
                <x-input-label :value="__('Auto Import States and Cities')" />
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="auto_import" value="1" class="peer sr-only" @checked((bool) old('auto_import', true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Import matching states and cities from the default dataset.') }}</span>
                </label>
                <x-input-error :messages="$errors->get('auto_import')" class="mt-2" />
            </div>
        </div>
    </div>
</div>

