﻿<x-admin-layout :title="__('Country Details')" :subtitle="__('Review country information and linked states.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Country') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $country->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Phone code') }}: {{ $country->phone_code ? '+' . $country->phone_code : __('Not set') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.countries.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.countries.edit', $country) }}" class="btn-primary">{{ __('Edit Country') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('ISO2') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $country->iso2 ?? __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('ISO3') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $country->iso3 ?? __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $country->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('States') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $country->states->count() }} linked state(s)</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('State Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">States currently linked to {{ $country->name }}.</p>
                </div>
                <a href="{{ route('admin.states.index', ['country' => $country->id]) }}" class="btn-secondary">{{ __('View in States') }}</a>
            </div>
            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($country->states as $state)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                        <p class="font-semibold text-ink">{{ $state->name }}</p>
                        <p class="mt-1 text-xs text-muted">{{ __('Code') }}: {{ $state->code ?: __('Not set') }}</p>
                        <p class="mt-2 text-xs text-muted">{{ $state->is_active ? __('Active') : __('Inactive') }}</p>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/60 p-6 text-center text-sm text-muted">
                        {{ __('No states linked to this country yet.') }}
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
