<x-admin-layout :title="__('Currencies')" :subtitle="__('Maintain currency codes and billing formats.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Locations') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Keep currency references aligned across billing and plans.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button
                        type="button"
                        class="btn-secondary"
                        x-data="{ loading: false }"
                        :disabled="loading"
                        @click="
                            loading = true;
                            fetch('{{ route('admin.currencies.fetch-rates') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]').content,
                                    'Accept': 'application/json'
                                }
                            })
                            .then(r => r.json())
                            .then(data => {
                                loading = false;
                                if (data.success) {
                                    alert(data.message);
                                    window.location.reload();
                                } else {
                                    alert('Error: ' + data.message);
                                }
                            })
                            .catch(e => { loading = false; alert('Failed to fetch rates.'); })
                        ">
                        <span x-show="!loading">{{ __('Update Rates') }}</span>
                        <span x-show="loading" x-cloak>{{ __('Updating...') }}</span>
                    </button>
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-currencies')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/currencies.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.currencies.create') }}" class="btn-primary">{{ __('Add Currency') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">Search</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by name, code, or symbol') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">Status</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="name_asc" @selected($sort === 'name_asc')>{{ __('Name (A-Z)') }}</option>
                        <option value="name_desc" @selected($sort === 'name_desc')>{{ __('Name (Z-A)') }}</option>
                        <option value="code_asc" @selected($sort === 'code_asc')>{{ __('Code (A-Z)') }}</option>
                        <option value="code_desc" @selected($sort === 'code_desc')>{{ __('Code (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.currencies.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="currencies-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Currency Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $currencies->count() }} of {{ $currencies->total() }} currencies.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.currencies.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-currency-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Currency') }}</th>
                            <th class="pb-3">{{ __('Code') }}</th>
                            <th class="pb-3">{{ __('Symbol') }}</th>
                            <th class="pb-3">{{ __('Precision') }}</th>
                            <th class="pb-3">{{ __('Exchange Rate') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($currencies as $currency)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $currency->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $currency->name }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $currency->code }}</td>
                                <td class="py-4 text-sm text-ink">{{ $currency->symbol ?: '-' }}</td>
                                <td class="py-4 text-sm text-ink">{{ $currency->precision }}</td>
                                <td class="py-4 text-sm text-ink font-mono">{{ rtrim(rtrim(number_format((float) $currency->exchange_rate, 6), '0'), '.') }}</td>
                                <td class="py-4">
                                    <span class="text-sm font-semibold text-ink">{{ $currency->is_active ? __('Active') : __('Inactive') }}</span>
                                </td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.currencies.show', $currency) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.currencies.edit', $currency) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-currency-delete-{{ $currency->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-currency-delete-{{ $currency->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.currencies.destroy', $currency) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">Delete {{ $currency->name }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="py-6 text-center text-sm text-muted">{{ __('No currencies found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($currencies as $currency)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $currency->name }}</p>
                                <p class="text-xs text-muted">{{ $currency->code }}</p>
                            </div>
                            <span class="badge">{{ $currency->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-sm text-ink">{{ __('Symbol') }}: {{ $currency->symbol ?: '-' }}</div>
                        <div class="mt-1 text-xs text-muted">{{ __('Precision') }}: {{ $currency->precision }}</div>
                        <div class="mt-1 text-xs text-muted font-mono">{{ __('Rate') }}: {{ rtrim(rtrim(number_format((float) $currency->exchange_rate, 6), '0'), '.') }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.currencies.show', $currency) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.currencies.edit', $currency) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No currencies found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-currency-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.currencies.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected currencies?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> currency(ies).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-currencies" :show="false" focusable>
                <form method="POST" action="{{ route('admin.currencies.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Currencies') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="currency_file" :value="__('CSV File')" />
                        <input id="currency_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $currencies->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
