﻿@php
    $isEdit = isset($currency) && $currency;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Currency Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Currency Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $currency->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="code" :value="__('Currency Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1 uppercase" maxlength="10" :value="old('code', $isEdit ? $currency->code : '')" placeholder="USD" required />
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="symbol" :value="__('Currency Symbol')" />
                <x-text-input id="symbol" name="symbol" type="text" class="mt-1" maxlength="20" :value="old('symbol', $isEdit ? $currency->symbol : '')" placeholder="$" />
                <x-input-error :messages="$errors->get('symbol')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="precision" :value="__('Decimal Precision')" />
                <x-text-input id="precision" name="precision" type="number" min="0" max="6" class="mt-1" :value="old('precision', $isEdit ? $currency->precision : 2)" />
                <x-input-error :messages="$errors->get('precision')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="exchange_rate" :value="__('Exchange Rate (vs USD)')" />
                <x-text-input id="exchange_rate" name="exchange_rate" type="number" step="0.000001" min="0" class="mt-1" :value="old('exchange_rate', $isEdit ? $currency->exchange_rate : '1.000000')" placeholder="1.000000" />
                <p class="mt-1 text-xs text-muted">{{ __('Rate relative to USD. Example: INR = 83.5, EUR = 0.92') }}</p>
                <x-input-error :messages="$errors->get('exchange_rate')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4">
            <x-input-label :value="__('Currency Status')" />
            <input type="hidden" name="is_active" value="0">
            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $currency->is_active : true))>
                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                </span>
                <span>{{ old('is_active', $isEdit ? $currency->is_active : true) ? __('Active') : __('Inactive') }}</span>
            </label>
        </div>
    </div>
</div>

