<x-admin-layout :title="__('Currency Details')" :subtitle="__('Review currency settings and metadata.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Currency') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $currency->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Code') }}: {{ $currency->code }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.currencies.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.currencies.edit', $currency) }}" class="btn-primary">{{ __('Edit Currency') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Symbol') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $currency->symbol ?: __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Precision') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $currency->precision }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $currency->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Last Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($currency->updated_at) }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
