﻿@php
    $isEdit = isset($language) && $language;
    $direction = old('direction', $isEdit ? $language->direction : 'ltr');
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Language Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Language Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $language->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="code" :value="__('Language Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1" maxlength="20" :value="old('code', $isEdit ? $language->code : '')" placeholder="en" required />
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="native_name" :value="__('Native Name')" />
                <x-text-input id="native_name" name="native_name" type="text" class="mt-1" maxlength="120" :value="old('native_name', $isEdit ? $language->native_name : '')" placeholder="English" />
                <x-input-error :messages="$errors->get('native_name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="direction" :value="__('Text Direction')" />
                <select id="direction" name="direction" class="input-field mt-1">
                    <option value="ltr" @selected($direction === 'ltr')>{{ __('Left to Right (LTR)') }}</option>
                    <option value="rtl" @selected($direction === 'rtl')>{{ __('Right to Left (RTL)') }}</option>
                </select>
                <x-input-error :messages="$errors->get('direction')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4">
            <x-input-label :value="__('Language Status')" />
            <input type="hidden" name="is_active" value="0">
            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $language->is_active : true))>
                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                </span>
                <span>{{ old('is_active', $isEdit ? $language->is_active : true) ? __('Active') : __('Inactive') }}</span>
            </label>
        </div>
    </div>
</div>

