<x-admin-layout :title="__('Language Details')" :subtitle="__('Review language configuration.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Language') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $language->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Code') }}: {{ $language->code }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.languages.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.languages.edit', $language) }}" class="btn-primary">{{ __('Edit Language') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Native Name') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $language->native_name ?: __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Direction') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ strtoupper($language->direction) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $language->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Last Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($language->updated_at) }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
