﻿@php
    $isEdit = isset($state) && $state;
    $selectedCountry = old('country_id', $isEdit ? $state->country_id : null);
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('State Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="country_id" :value="__('Country')" />
                <select id="country_id" name="country_id" class="input-field mt-1" required>
                    <option value="">{{ __('Select country') }}</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @selected((string) $selectedCountry === (string) $country->id)>{{ $country->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('country_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="name" :value="__('State Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $state->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="code" :value="__('State Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1" maxlength="10" :value="old('code', $isEdit ? $state->code : '')" />
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4">
            <x-input-label :value="__('State Status')" />
            <input type="hidden" name="is_active" value="0">
            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $state->is_active : true))>
                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                </span>
                <span>{{ old('is_active', $isEdit ? $state->is_active : true) ? __('Active') : __('Inactive') }}</span>
            </label>
        </div>
    </div>
</div>

