﻿<x-admin-layout :title="__('State Details')" :subtitle="__('Review state information and linked cities.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('State') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $state->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Country') }}: {{ $state->country?->name ?? __('Not set') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.states.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.states.edit', $state) }}" class="btn-primary">{{ __('Edit State') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Code') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $state->code ?: __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $state->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Cities') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $state->cities->count() }} linked city(ies)</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('City Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Cities currently linked to {{ $state->name }}.</p>
                </div>
                <a href="{{ route('admin.cities.index', ['state' => $state->id]) }}" class="btn-secondary">{{ __('View in Cities') }}</a>
            </div>
            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($state->cities as $city)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                        <p class="font-semibold text-ink">{{ $city->name }}</p>
                        <p class="mt-2 text-xs text-muted">{{ $city->is_active ? __('Active') : __('Inactive') }}</p>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/60 p-6 text-center text-sm text-muted">
                        {{ __('No cities linked to this state yet.') }}
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
