<x-admin-layout :title="__('Newsletter Subscribers')" :subtitle="__('Manage email subscribers.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Subscriber List') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('View and manage newsletter subscribers.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.newsletter-subscribers.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search email or name') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                        <option value="email_asc" @selected($sort === 'email_asc')>{{ __('Email (A-Z)') }}</option>
                        <option value="email_desc" @selected($sort === 'email_desc')>{{ __('Email (Z-A)') }}</option>
                        <option value="name_asc" @selected($sort === 'name_asc')>{{ __('Name (A-Z)') }}</option>
                        <option value="name_desc" @selected($sort === 'name_desc')>{{ __('Name (Z-A)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.newsletter-subscribers.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope>
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Subscriber Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $subscribers->count() }} of {{ $subscribers->total() }} subscribers.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.newsletter-subscribers.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-subscriber-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Email') }}</th>
                            <th class="pb-3">{{ __('Name') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Subscribed At') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($subscribers as $subscriber)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $subscriber->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $subscriber->email }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $subscriber->name ?: '-' }}</td>
                                <td class="py-4 text-sm">
                                    @if ($subscriber->is_active)
                                        <span class="inline-flex items-center rounded-full bg-green-100 px-2.5 py-0.5 text-xs font-medium text-green-800 dark:bg-green-900/30 dark:text-green-400">{{ __('Active') }}</span>
                                    @else
                                        <span class="inline-flex items-center rounded-full bg-red-100 px-2.5 py-0.5 text-xs font-medium text-red-800 dark:bg-red-900/30 dark:text-red-400">{{ __('Inactive') }}</span>
                                    @endif
                                </td>
                                <td class="py-4 text-sm text-ink">{{ \App\Support\FormatSettings::date($subscriber->subscribed_at) ?? '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.newsletter-subscribers.show', $subscriber) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-subscriber-delete-{{ $subscriber->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-subscriber-delete-{{ $subscriber->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.newsletter-subscribers.destroy', $subscriber) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this subscriber?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No subscribers found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <x-modal name="confirm-subscriber-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.newsletter-subscribers.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected subscribers?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {{ __('You are about to remove') }} <span class="font-semibold text-ink" data-bulk-selected>0</span> {{ __('subscriber(s).') }}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $subscribers->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
