<x-admin-layout :title="__('Subscriber Details')" :subtitle="__('View newsletter subscriber information.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Subscriber') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $subscriber->email }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $subscriber->name ?: __('No name provided') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.newsletter-subscribers.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Email') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $subscriber->email }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Name') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $subscriber->name ?: '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        @if ($subscriber->is_active)
                            <span class="inline-flex items-center rounded-full bg-green-100 px-2.5 py-0.5 text-xs font-medium text-green-800 dark:bg-green-900/30 dark:text-green-400">{{ __('Active') }}</span>
                        @else
                            <span class="inline-flex items-center rounded-full bg-red-100 px-2.5 py-0.5 text-xs font-medium text-red-800 dark:bg-red-900/30 dark:text-red-400">{{ __('Inactive') }}</span>
                        @endif
                    </p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Subscribed At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($subscriber->subscribed_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Unsubscribed At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($subscriber->unsubscribed_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($subscriber->created_at) ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
