<x-admin-layout :title="__('Operations')" :subtitle="__('Manage content, support, and localization')">

    <div class="space-y-8">
        {{-- Support & Reports --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Support & Reports') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @can('viewAny', \App\Models\SupportTicket::class)
                <a href="{{ route('admin.support-tickets.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="9"></circle>
                            <path d="M12 8v4"></path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Support Tickets') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage customer support tickets and inquiries.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\SupportTicketAssignment::class)
                <a href="{{ route('admin.ticket-assignments.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M8 3h8a2 2 0 0 1 2 2v4"></path>
                            <path d="M16 21H8a2 2 0 0 1-2-2v-4"></path>
                            <path d="M3 12h18"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Ticket Assignments') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Assign and manage support ticket routing.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\Report::class)
                <a href="{{ route('admin.reports.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 3v18h18"></path>
                            <path d="M7 14l4-4 3 3 5-6"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Reports') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('View analytics, revenue, and usage reports.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\NewsletterSubscriber::class)
                <a href="{{ route('admin.newsletter-subscribers.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="2" y="4" width="20" height="16" rx="2"></rect>
                            <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Newsletter Subscribers') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage email subscribers and mailing lists.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                <a href="{{ route('admin.contact-queries.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Contact Queries') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('View and manage messages from the contact form.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
            </div>
        </div>

        {{-- Content Management --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Content Management') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                <a href="{{ route('admin.frontend-settings.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Frontend Settings') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage content for About, Contact, Privacy, Terms, and Cookies pages.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>

                @can('viewAny', \App\Models\Faq::class)
                <a href="{{ route('admin.faqs.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="9"></circle>
                            <path d="M9.5 9a2.5 2.5 0 1 1 4.5 1.6c-.5.6-1.5 1-1.5 2.4"></path>
                            <path d="M12 17h.01"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('FAQs') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage frequently asked questions.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\Testimonial::class)
                <a href="{{ route('admin.testimonials.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 21c3 0 7-1 7-8V5c0-1.25-.756-2.017-2-2H4c-1.25 0-2 .75-2 1.972V11c0 1.25.75 2 2 2 1 0 1 0 1 1v1c0 1-1 2-2 2s-1 .008-1 1.031V21z"></path>
                            <path d="M15 21c3 0 7-1 7-8V5c0-1.25-.757-2.017-2-2h-4c-1.25 0-2 .75-2 1.972V11c0 1.25.75 2 2 2h.75c0 2.25.25 4-2.75 8z"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Testimonials') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage customer testimonials and reviews.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\FactStat::class)
                <a href="{{ route('admin.fact-stats.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 3v18h18"></path>
                            <rect x="7" y="10" width="3" height="8" rx="0.5"></rect>
                            <rect x="13" y="6" width="3" height="12" rx="0.5"></rect>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Facts & Stats') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage counters and statistics displayed on frontend.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\BlogPost::class)
                <a href="{{ route('admin.blog-posts.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 4h16v16H4z"></path>
                            <path d="M8 8h8"></path>
                            <path d="M8 12h8"></path>
                            <path d="M8 16h5"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Blog Posts') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Create and manage blog articles.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\BlogCategory::class)
                <a href="{{ route('admin.blog-categories.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="4" width="18" height="16" rx="2"></rect>
                            <path d="M7 8h10"></path>
                            <path d="M7 12h6"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Blog Categories') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Organize blog posts into categories.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\Page::class)
                <a href="{{ route('admin.pages.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                            <line x1="16" x2="8" y1="13" y2="13"></line>
                            <line x1="16" x2="8" y1="17" y2="17"></line>
                            <line x1="10" x2="8" y1="9" y2="9"></line>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Pages') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage custom pages created by administrators.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan
            </div>
        </div>

        {{-- Localization --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Localization') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @can('viewAny', \App\Models\Country::class)
                <a href="{{ route('admin.countries.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <path d="M2 12h20"></path>
                            <path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Countries') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage countries available in the system.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\State::class)
                <a href="{{ route('admin.states.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 10c0 6-9 11-9 11s-9-5-9-11a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('States') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage states and provinces.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\City::class)
                <a href="{{ route('admin.cities.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="18" height="18" rx="2"></rect>
                            <path d="M7 7h4v4H7z"></path>
                            <path d="M13 7h4v4h-4z"></path>
                            <path d="M7 13h4v4H7z"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Cities') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage cities and localities.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\Currency::class)
                <a href="{{ route('admin.currencies.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="9"></circle>
                            <path d="M8 10h6"></path>
                            <path d="M8 14h6"></path>
                            <path d="M14 7v10"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Currencies') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage currencies and exchange rates.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\Language::class)
                <a href="{{ route('admin.languages.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 5h7"></path>
                            <path d="M4 9h7"></path>
                            <path d="M4 13h4"></path>
                            <path d="M13 5h7"></path>
                            <path d="M13 9h7"></path>
                            <path d="M13 13h4"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Languages') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage languages and translations.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan
            </div>
        </div>
    </div>

</x-admin-layout>
